/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.mapping;

import com.naskar.fluentquery.impl.MethodRecordProxy;
import com.naskar.fluentquery.impl.TypeUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Mapping<T> {
    private Class<T> clazz;
    private String tableName;
    private Map<List<Method>, String> columns;
    private MethodRecordProxy<T> proxy;

    public Mapping<T> to(Class<T> clazz, String tableName) {
        this.clazz = clazz;
        this.tableName = tableName;
        this.proxy = TypeUtils.createProxy(clazz);
        this.columns = new HashMap<List<Method>, String>();
        return this;
    }

    public Mapping<T> map(Consumer<T> action, String columnName) {
        this.proxy.clear();
        action.accept(this.proxy.getProxy());
        this.columns.put(new ArrayList<Method>(this.proxy.getMethods()), columnName);
        return this;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName(List<Method> key) {
        return this.columns.get(key);
    }

    protected MethodRecordProxy<T> getProxy() {
        return this.proxy;
    }

    protected Map<List<Method>, String> getColumns() {
        return this.columns;
    }
}

