/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.impl;

import com.naskar.fluentquery.Join;
import com.naskar.fluentquery.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class PredicateImpl<T, R, I, B>
implements Predicate<T, R, B> {
    private B impl;
    private Function<T, R> property;
    private Type type;
    private List<Consumer<Predicate<T, R, I>>> actions;

    public PredicateImpl(B impl, Function<T, R> property, Type type) {
        this.impl = impl;
        this.property = property;
        this.type = type;
        this.actions = new ArrayList<Consumer<Predicate<T, R, I>>>();
    }

    public Function<T, R> getProperty() {
        return this.property;
    }

    public Type getType() {
        return this.type;
    }

    public List<Consumer<Predicate<T, R, I>>> getActions() {
        return this.actions;
    }

    @Override
    public B eq(R value) {
        this.actions.add(i -> i.eq(value));
        return this.impl;
    }

    @Override
    public B ne(R value) {
        this.actions.add(i -> i.ne(value));
        return this.impl;
    }

    @Override
    public B gt(R value) {
        this.actions.add(i -> i.gt(value));
        return this.impl;
    }

    @Override
    public B ge(R value) {
        this.actions.add(i -> i.ge(value));
        return this.impl;
    }

    @Override
    public B lt(R value) {
        this.actions.add(i -> i.lt(value));
        return this.impl;
    }

    @Override
    public B le(R value) {
        this.actions.add(i -> i.le(value));
        return this.impl;
    }

    @Override
    public B like(R value) {
        this.actions.add(i -> i.like(value));
        return this.impl;
    }

    @Override
    public B isNull() {
        this.actions.add(i -> i.isNull());
        return this.impl;
    }

    @Override
    public B isNotNull() {
        this.actions.add(i -> i.isNotNull());
        return this.impl;
    }

    @Override
    public <J> B in(Class<J> clazz, Join<J, T> action) {
        this.actions.add(i -> i.in(clazz, action));
        return this.impl;
    }

    @Override
    public <J> B notIn(Class<J> clazz, Join<J, T> action) {
        this.actions.add(i -> i.notIn(clazz, action));
        return this.impl;
    }

    public static enum Type {
        SPEC_AND,
        SPEC_OR,
        AND,
        OR;

    }
}

