/*
 * Decompiled with CFR 0.152.
 */
package com.github.naoghuman.lib.fxml.internal;

import java.util.Objects;

public final class DefaultFXMLValidator {
    public static boolean isNull(Object obj) {
        return Objects.isNull(obj);
    }

    public static boolean nonNull(Object obj) {
        return Objects.nonNull(obj);
    }

    public static <T> void requireNonNull(T value) throws NullPointerException {
        Objects.requireNonNull(value, "The attribute [value] can't be NULL.");
    }

    public static void requireNonNullAndNotEmpty(String value) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(value, "The attribute [value] can't be NULL.");
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException("The attribute [value] can't be EMPTY.");
        }
    }

    public static void requireEndsWith(String value, String suffix) {
        DefaultFXMLValidator.requireNonNullAndNotEmpty(value);
        DefaultFXMLValidator.requireNonNullAndNotEmpty(suffix);
        if (!value.endsWith(suffix)) {
            throw new IllegalArgumentException(String.format("The attribute [value=%s] must ends with the suffix: %s", value, suffix));
        }
    }
}

