/*
 * Decompiled with CFR 0.152.
 */
package com.nacro.indent;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.util.Xml;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.nacro.indent.IndentSpanString;
import com.nacro.indent.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class IndentationTextLayout
extends LinearLayout {
    private boolean mHasTitle;
    private int[] mIndexOfLabelInLinearLayout;
    private int mLabelStyle;
    private int mSubTextOfLabel;
    private int mLeadingMargin;
    private int mLabelColor;
    private AttributeSet mTextAttr;
    private static final String TAG = "IndentationTextView";

    public IndentationTextLayout(Context context) {
        this(context, null);
    }

    public IndentationTextLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndentationTextLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        if (attrs == null) {
            this.mLeadingMargin = this.convertDpToPx(this.getContext(), 24);
            this.mLabelStyle = 0;
            this.mSubTextOfLabel = 0;
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IndentationTextLayout, defStyleAttr, 0);
        String title = a.getString(R.styleable.IndentationTextLayout_title);
        int strArrayId = a.getResourceId(R.styleable.IndentationTextLayout_array_text, 0);
        this.mLabelStyle = a.getInt(R.styleable.IndentationTextLayout_label_style, 0);
        this.mSubTextOfLabel = a.getInt(R.styleable.IndentationTextLayout_sub_text_of_label, 0);
        this.mLeadingMargin = this.convertDpToPx(this.getContext(), a.getInt(R.styleable.IndentationTextLayout_leading_margin, 24));
        this.mLabelColor = a.getColor(R.styleable.IndentationTextLayout_label_color, 0);
        int textAttrId = a.getResourceId(R.styleable.IndentationTextLayout_text_attr, 0);
        if (textAttrId != 0) {
            this.setTextViewAttr(textAttrId);
        }
        a.recycle();
        this.setTitle(title);
        if (strArrayId != 0) {
            this.setContent(this.getResources().getStringArray(strArrayId));
        }
    }

    public AttributeSet getTextViewAttr() {
        return this.mTextAttr;
    }

    public void setTextViewAttr(int textAttrId) {
        XmlResourceParser parser = this.getResources().getLayout(textAttrId);
        int state = 0;
        do {
            try {
                state = parser.next();
            }
            catch (IOException | XmlPullParserException e1) {
                e1.printStackTrace();
            }
            if (state != 2 || !parser.getName().equals("TextView")) continue;
            this.mTextAttr = Xml.asAttributeSet((XmlPullParser)parser);
            break;
        } while (state != 1);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof IndentationTextLayout && ((IndentationTextLayout)child).getSubTextOfLabel() != 0 && ((IndentationTextLayout)child).getSubTextOfLabel() != this.mIndexOfLabelInLinearLayout.length) {
            int which = ((IndentationTextLayout)child).getSubTextOfLabel();
            super.addView(child, this.mIndexOfLabelInLinearLayout[which], params);
            this.updateIndex(which);
        } else {
            super.addView(child, index, params);
        }
    }

    private void updateIndex(int start) {
        int i = start + 1;
        while (i < this.mIndexOfLabelInLinearLayout.length) {
            int n = i++;
            this.mIndexOfLabelInLinearLayout[n] = this.mIndexOfLabelInLinearLayout[n] + 1;
        }
    }

    public boolean hasTitle() {
        return this.mHasTitle;
    }

    public void setContent(CharSequence[] array) {
        if (this.hasTitle()) {
            this.removeViews(1, this.getChildCount() - 1);
        } else {
            this.removeAllViews();
        }
        this.mIndexOfLabelInLinearLayout = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.mIndexOfLabelInLinearLayout[i] = this.hasTitle() ? i + 1 : i;
            TextView textView = new TextView(this.getContext(), this.mTextAttr);
            SpannableString spStr = new SpannableString(array[i]);
            spStr.setSpan((Object)new IndentSpanString(this.mLeadingMargin, this.mLabelStyle, i + 1, this.mLabelColor), 0, spStr.length(), 34);
            textView.setText((CharSequence)spStr);
            this.addView((View)textView);
        }
    }

    public void setContentOfLabel(int which, CharSequence content) throws Exception {
        View view;
        if (this.mIndexOfLabelInLinearLayout == null) {
            throw new Exception("No labels");
        }
        SpannableString spStr = content instanceof SpannableString ? (SpannableString)content : new SpannableString(content);
        IndentSpanString[] indentSpanString = (IndentSpanString[])spStr.getSpans(0, content.length(), IndentSpanString.class);
        if (indentSpanString.length == 0) {
            spStr.setSpan((Object)new IndentSpanString(this.mLeadingMargin, this.mLabelStyle, which, this.mLabelColor), 0, content.length(), 34);
        }
        if ((view = this.getChildAt(this.mIndexOfLabelInLinearLayout[which - 1])) == null) {
            TextView textView = new TextView(this.getContext(), this.mTextAttr);
            textView.setText((CharSequence)spStr);
            this.addView((View)textView);
        } else {
            ((TextView)view).setText((CharSequence)spStr);
        }
    }

    public void setTitle(CharSequence title) {
        if (title == null) {
            this.mHasTitle = false;
            return;
        }
        View view = this.getChildAt(0);
        if (view != null) {
            ((TextView)view).setText(title);
        } else {
            TextView textView = new TextView(this.getContext(), this.mTextAttr);
            textView.setText(title);
            this.addView((View)textView, 0);
        }
        this.mHasTitle = true;
    }

    public void setSubTextOfLabel(int subTextOfLabel) {
        this.mSubTextOfLabel = subTextOfLabel;
    }

    public void setLeadingMargin(int leadingMargin) {
        this.mLeadingMargin = leadingMargin;
    }

    public int getSubTextOfLabel() {
        return this.mSubTextOfLabel;
    }

    public CharSequence getContentOfLabel(int which) {
        return ((TextView)this.getChildAt(this.mIndexOfLabelInLinearLayout[which - 1])).getText();
    }

    public CharSequence[] getContents() {
        ArrayList<CharSequence> contents = new ArrayList<CharSequence>();
        for (int i = 0; i < this.mIndexOfLabelInLinearLayout.length; ++i) {
            contents.add(((TextView)this.getChildAt(this.mIndexOfLabelInLinearLayout[i - 1])).getText());
        }
        return contents.toArray(new CharSequence[0]);
    }

    private int convertDpToPx(Context context, int dp) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
    }
}

