/*
 * Decompiled with CFR 0.152.
 */
package com.nacro.indent;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import com.nacro.indent.NumToChineseNum;

public class IndentSpanString
implements LeadingMarginSpan {
    private int mLeadingMargin;
    private int mLabelStyle;
    private int mLabelOrder;
    private int mLabelColor;
    private CharSequence mCustomBullet;
    public static final int LabelType_None = -1;
    public static final int LabelType_Number = 0;
    public static final int LabelType_Dot = 1;
    public static final int LabelType_Letter = 2;
    public static final int LabelType_Parentheses = 3;
    public static final int LabelType_Chinese_Num_Dayton = 4;
    public static final int LabelType_Chinese_Num_Parentheses = 5;
    public static final int LabelType_Custom = -2;

    public IndentSpanString(int leadingMargin) {
        this(leadingMargin, 0);
    }

    public IndentSpanString(int leadingMargin, int labelStyle) {
        this(leadingMargin, labelStyle, 1, 0);
    }

    public IndentSpanString(int leadingMargin, int labelStyle, int labelOrder, int labelColor) {
        this.mLeadingMargin = leadingMargin;
        this.mLabelStyle = labelStyle;
        this.mLabelOrder = labelOrder > 0 ? labelOrder : 1;
        this.mLabelColor = labelColor;
    }

    public IndentSpanString(int leadingMargin, CharSequence customBullet, int labelColor) {
        this.mLeadingMargin = leadingMargin;
        this.mLabelStyle = -2;
        this.mCustomBullet = customBullet;
        this.mLabelColor = labelColor;
    }

    public int getLeadingMargin(boolean first) {
        return this.mLeadingMargin;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        int tempColor = p.getColor();
        if (this.mLabelColor != 0) {
            p.setColor(this.mLabelColor);
        }
        if (first) {
            switch (this.mLabelStyle) {
                case -1: {
                    break;
                }
                case 0: {
                    c.drawText(this.mLabelOrder + ".", 0.0f, (float)baseline, p);
                    break;
                }
                case 1: {
                    c.drawText("\u30fb", 0.0f, (float)baseline, p);
                    break;
                }
                case 2: {
                    c.drawText(String.valueOf(Character.toChars(this.mLabelOrder + 96)) + ".", 0.0f, (float)baseline, p);
                    break;
                }
                case 3: {
                    c.drawText("(" + this.mLabelOrder + ")", 0.0f, (float)baseline, p);
                    break;
                }
                case 4: {
                    c.drawText(NumToChineseNum.toChineseNum(this.mLabelOrder) + "\u3001 ", 0.0f, (float)baseline, p);
                    break;
                }
                case 5: {
                    c.drawText("(" + NumToChineseNum.toChineseNum(this.mLabelOrder) + ")", 0.0f, (float)baseline, p);
                    break;
                }
                case -2: {
                    if (this.mCustomBullet == null) break;
                    c.drawText(this.mCustomBullet, 0, this.mCustomBullet.length(), 0.0f, (float)baseline, p);
                }
            }
        }
        p.setColor(tempColor);
    }
}

