/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.message;

import com.github.myzhan.locust4j.message.LongIntMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePacker;

public class Visitor {
    final MessagePacker packer;

    public Visitor(MessagePacker packer) {
        this.packer = packer;
    }

    public void visit(Object value) throws IOException {
        if (null == value) {
            this.visitNull();
        } else if (value instanceof String) {
            this.visitString(value);
        } else if (value instanceof Integer) {
            this.visitInt(value);
        } else if (value instanceof Long) {
            this.visitLong(value);
        } else if (value instanceof Boolean) {
            this.visitBool(value);
        } else if (value instanceof Float) {
            this.visitFloat(value);
        } else if (value instanceof Double) {
            this.visitDouble(value);
        } else if (value instanceof Map) {
            this.visitMap(value);
        } else if (value instanceof List) {
            this.visitList(value);
        } else if (value instanceof LongIntMap) {
            this.visitRps(value);
        } else {
            throw new IOException("Cannot pack type unknown type:" + value.getClass().getSimpleName());
        }
    }

    private void visitNull() throws IOException {
        this.packer.packNil();
    }

    private void visitString(Object value) throws IOException {
        this.packer.packString((String)value);
    }

    private void visitInt(Object value) throws IOException {
        this.packer.packInt(((Integer)value).intValue());
    }

    private void visitLong(Object value) throws IOException {
        this.packer.packLong(((Long)value).longValue());
    }

    private void visitBool(Object value) throws IOException {
        this.packer.packBoolean(((Boolean)value).booleanValue());
    }

    private void visitFloat(Object value) throws IOException {
        this.packer.packFloat(((Float)value).floatValue());
    }

    private void visitDouble(Object value) throws IOException {
        this.packer.packDouble(((Double)value).doubleValue());
    }

    private void visitMap(Object value) throws IOException {
        Map map = (Map)value;
        this.packer.packMapHeader(map.size());
        for (Map.Entry entry : map.entrySet()) {
            this.visitString(entry.getKey());
            this.visit(entry.getValue());
        }
    }

    private void visitList(Object value) throws IOException {
        List list = (List)value;
        this.packer.packArrayHeader(list.size());
        for (Object object : list) {
            this.visit(object);
        }
    }

    private void visitRps(Object value) throws IOException {
        LongIntMap longIntMap = (LongIntMap)value;
        this.packer.packMapHeader(longIntMap.internalStore.size());
        for (Map.Entry<Long, Integer> entry : longIntMap.internalStore.entrySet()) {
            this.packer.packLong(entry.getKey().longValue());
            this.packer.packInt(entry.getValue().intValue());
        }
    }
}

