/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.rpc;

import com.github.myzhan.locust4j.Log;
import com.github.myzhan.locust4j.message.Message;
import com.github.myzhan.locust4j.rpc.Client;
import java.io.IOException;
import org.zeromq.ZMQ;

public class ZeromqClient
implements Client {
    private ZMQ.Context context = ZMQ.context((int)1);
    private String identity;
    private ZMQ.Socket dealerSocket;

    public ZeromqClient(String host, int port, String nodeID) {
        this.identity = nodeID;
        this.dealerSocket = this.context.socket(5);
        this.dealerSocket.setIdentity(this.identity.getBytes());
        this.dealerSocket.connect(String.format("tcp://%s:%d", host, port));
        Log.debug(String.format("Locust4j is connected to master(%s:%d)", host, port));
    }

    @Override
    public Message recv() throws IOException {
        byte[] bytes = this.dealerSocket.recv();
        return new Message(bytes);
    }

    @Override
    public void send(Message message) throws IOException {
        byte[] bytes = message.getBytes();
        this.dealerSocket.send(bytes);
    }

    @Override
    public void close() {
        this.dealerSocket.close();
        this.context.close();
    }
}

