/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.rpc;

import com.github.myzhan.locust4j.Log;
import com.github.myzhan.locust4j.message.Message;
import com.github.myzhan.locust4j.rpc.Client;
import java.io.IOException;
import org.zeromq.ZMQ;

public class ZeromqClient
implements Client {
    private ZMQ.Context context = ZMQ.context((int)2);
    private ZMQ.Socket pushSocket = this.context.socket(8);
    private ZMQ.Socket pullSocket;

    public ZeromqClient(String host, int port) {
        this.pushSocket.connect(String.format("tcp://%s:%d", host, port));
        this.pullSocket = this.context.socket(7);
        this.pullSocket.connect(String.format("tcp://%s:%d", host, port + 1));
        Log.debug(String.format("Locust4j is connected to master(%s:%d|%d)", host, port, port + 1));
    }

    @Override
    public Message recv() throws IOException {
        byte[] bytes = this.pullSocket.recv();
        return new Message(bytes);
    }

    @Override
    public void send(Message message) throws IOException {
        byte[] bytes = message.getBytes();
        this.pushSocket.send(bytes);
    }

    @Override
    public void close() {
        this.pullSocket.close();
        this.pushSocket.close();
    }
}

