/*
 * Decompiled with CFR 0.152.
 */
package in.myinnos.alphabetsindexfastscrollrecycler;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.recyclerview.widget.RecyclerView;
import in.myinnos.alphabetsindexfastscrollrecycler.IndexFastScrollRecyclerSection;
import in.myinnos.alphabetsindexfastscrollrecycler.R;

public class IndexFastScrollRecyclerView
extends RecyclerView {
    private IndexFastScrollRecyclerSection mScroller = null;
    private GestureDetector mGestureDetector = null;
    private boolean mEnabled = true;
    public int setIndexTextSize = 12;
    public float mIndexbarWidth = 20.0f;
    public float mIndexbarMargin = 5.0f;
    public int mPreviewPadding = 5;
    public int mIndexBarCornerRadius = 5;
    public float mIndexBarTransparentValue = 0.6f;
    public int mIndexBarStrokeWidth = 2;
    @ColorInt
    public int mSetIndexBarStrokeColor = -16777216;
    @ColorInt
    public int mIndexbarBackgroudColor = -16777216;
    @ColorInt
    public int mIndexbarTextColor = -1;
    @ColorInt
    public int indexbarHighLightTextColor = -16777216;
    public int mPreviewTextSize = 50;
    @ColorInt
    public int mPreviewBackgroudColor = -16777216;
    @ColorInt
    public int mPreviewTextColor = -1;
    public float mPreviewTransparentValue = 0.4f;

    public IndexFastScrollRecyclerView(Context context) {
        super(context);
    }

    public IndexFastScrollRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public IndexFastScrollRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray;
        this.mScroller = new IndexFastScrollRecyclerSection(context, this);
        if (attrs != null && (typedArray = context.obtainStyledAttributes(attrs, R.styleable.IndexFastScrollRecyclerView, 0, 0)) != null) {
            try {
                this.setIndexTextSize = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setIndexTextSize, this.setIndexTextSize);
                this.mIndexbarWidth = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarWidth, this.mIndexbarWidth);
                this.mIndexbarMargin = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarMargin, this.mIndexbarMargin);
                this.mPreviewPadding = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setPreviewPadding, this.mPreviewPadding);
                this.mIndexBarCornerRadius = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setIndexBarCornerRadius, this.mIndexBarCornerRadius);
                this.mIndexBarTransparentValue = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexBarTransparentValue, this.mIndexBarTransparentValue);
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor)) {
                    this.mIndexbarBackgroudColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor));
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColor)) {
                    this.mIndexbarTextColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColor));
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor)) {
                    this.indexbarHighLightTextColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor));
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColorRes)) {
                    this.mIndexbarBackgroudColor = typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarColorRes, this.mIndexbarBackgroudColor);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColorRes)) {
                    this.mIndexbarTextColor = typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColorRes, this.mIndexbarTextColor);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColorRes)) {
                    this.indexbarHighLightTextColor = typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor, this.indexbarHighLightTextColor);
                }
                this.mPreviewTextSize = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setPreviewTextSize, this.mPreviewTextSize);
                this.mPreviewTransparentValue = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setPreviewTransparentValue, this.mPreviewTransparentValue);
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setPreviewColor)) {
                    this.mPreviewBackgroudColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setPreviewColor));
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setPreviewTextColor)) {
                    this.mPreviewTextColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setPreviewTextColor));
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeWidth)) {
                    this.mIndexBarStrokeWidth = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeWidth, this.mIndexBarStrokeWidth);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeColor)) {
                    this.mSetIndexBarStrokeColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeColor));
                }
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mScroller != null) {
            this.mScroller.draw(canvas);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mEnabled) {
            if (this.mScroller != null && this.mScroller.onTouchEvent(ev)) {
                return true;
            }
            if (this.mGestureDetector == null) {
                this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                        return super.onFling(e1, e2, velocityX, velocityY);
                    }
                });
            }
            this.mGestureDetector.onTouchEvent(ev);
        }
        return super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mEnabled && this.mScroller != null && this.mScroller.contains(ev.getX(), ev.getY())) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        super.setAdapter(adapter);
        if (this.mScroller != null) {
            this.mScroller.setAdapter(adapter);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mScroller != null) {
            this.mScroller.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public void setIndexTextSize(int value) {
        this.mScroller.setIndexTextSize(value);
    }

    public void setIndexbarWidth(float value) {
        this.mScroller.setIndexbarWidth(value);
    }

    public void setIndexbarMargin(float value) {
        this.mScroller.setIndexbarMargin(value);
    }

    public void setPreviewPadding(int value) {
        this.mScroller.setPreviewPadding(value);
    }

    public void setIndexBarCornerRadius(int value) {
        this.mScroller.setIndexBarCornerRadius(value);
    }

    public void setIndexBarTransparentValue(float value) {
        this.mScroller.setIndexBarTransparentValue(value);
    }

    public void setTypeface(Typeface typeface) {
        this.mScroller.setTypeface(typeface);
    }

    public void setIndexBarVisibility(boolean shown) {
        this.mScroller.setIndexBarVisibility(shown);
        this.mEnabled = shown;
    }

    public void setIndexBarStrokeVisibility(boolean shown) {
        this.mScroller.setIndexBarStrokeVisibility(shown);
    }

    public void setIndexBarStrokeColor(String color) {
        this.mScroller.setIndexBarStrokeColor(Color.parseColor((String)color));
    }

    public void setIndexBarStrokeWidth(int value) {
        this.mScroller.setIndexBarStrokeWidth(value);
    }

    public void setPreviewVisibility(boolean shown) {
        this.mScroller.setPreviewVisibility(shown);
    }

    public void setPreviewTextSize(int value) {
        this.mScroller.setPreviewTextSize(value);
    }

    public void setPreviewColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setPreviewColor(colorValue);
    }

    public void setPreviewColor(String color) {
        this.mScroller.setPreviewColor(Color.parseColor((String)color));
    }

    public void setPreviewTextColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setPreviewTextColor(colorValue);
    }

    public void setPreviewTransparentValue(float value) {
        this.mScroller.setPreviewTransparentValue(value);
    }

    public void setPreviewTextColor(String color) {
        this.mScroller.setPreviewTextColor(Color.parseColor((String)color));
    }

    public void setIndexBarColor(String color) {
        this.mScroller.setIndexBarColor(Color.parseColor((String)color));
    }

    public void setIndexBarColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexBarColor(colorValue);
    }

    public void setIndexBarTextColor(String color) {
        this.mScroller.setIndexBarTextColor(Color.parseColor((String)color));
    }

    public void setIndexBarTextColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexBarTextColor(colorValue);
    }

    public void setIndexbarHighLightTextColor(String color) {
        this.mScroller.setIndexbarHighLightTextColor(Color.parseColor((String)color));
    }

    public void setIndexbarHighLightTextColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexbarHighLightTextColor(colorValue);
    }

    public void setIndexBarHighLightTextVisibility(boolean shown) {
        this.mScroller.setIndexBarHighLightTextVisibility(shown);
    }

    public void updateSections() {
        this.mScroller.updateSections();
    }
}

