/*
 * Decompiled with CFR 0.152.
 */
package in.myinnos.alphabetsindexfastscrollrecycler;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import in.myinnos.alphabetsindexfastscrollrecycler.IndexFastScrollRecyclerSection;
import in.myinnos.alphabetsindexfastscrollrecycler.R;

public class IndexFastScrollRecyclerView
extends RecyclerView {
    private IndexFastScrollRecyclerSection mScroller = null;
    private GestureDetector mGestureDetector = null;
    private boolean mEnabled = true;
    public int setIndexTextSize = 12;
    public float mIndexbarWidth = 20.0f;
    public float mIndexbarMargin = 5.0f;
    public int mPreviewPadding = 5;
    public int mIndexBarCornerRadius = 5;
    public float mIndexBarTransparentValue = 0.6f;
    @ColorInt
    public int mIndexbarBackgroudColor = -16777216;
    @ColorInt
    public int mIndexbarTextColor = -1;
    @ColorInt
    public int mIndexbarHighLateTextColor = -16777216;

    public IndexFastScrollRecyclerView(Context context) {
        super(context);
    }

    public IndexFastScrollRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public IndexFastScrollRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray;
        if (attrs != null && (typedArray = context.obtainStyledAttributes(attrs, R.styleable.IndexFastScrollRecyclerView, 0, 0)) != null) {
            try {
                this.setIndexTextSize = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setIndexTextSize, this.setIndexTextSize);
                this.mIndexbarWidth = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarWidth, this.mIndexbarWidth);
                this.mIndexbarMargin = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarMargin, this.mIndexbarMargin);
                this.mPreviewPadding = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setPreviewPadding, this.mPreviewPadding);
                this.mIndexBarCornerRadius = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setIndexBarCornerRadius, this.mIndexBarCornerRadius);
                this.mIndexBarTransparentValue = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexBarTransparentValue, this.mIndexBarTransparentValue);
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor)) {
                    this.mIndexbarBackgroudColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor));
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColor)) {
                    this.mIndexbarTextColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColor));
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor)) {
                    this.mIndexbarHighLateTextColor = Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor));
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColorRes)) {
                    this.mIndexbarBackgroudColor = typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarColorRes, this.mIndexbarBackgroudColor);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColorRes)) {
                    this.mIndexbarTextColor = typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColorRes, this.mIndexbarTextColor);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColorRes)) {
                    this.mIndexbarHighLateTextColor = typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor, this.mIndexbarHighLateTextColor);
                }
            }
            finally {
                typedArray.recycle();
            }
        }
        this.mScroller = new IndexFastScrollRecyclerSection(context, this);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mScroller != null) {
            this.mScroller.draw(canvas);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mEnabled) {
            if (this.mScroller != null && this.mScroller.onTouchEvent(ev)) {
                return true;
            }
            if (this.mGestureDetector == null) {
                this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                        return super.onFling(e1, e2, velocityX, velocityY);
                    }
                });
            }
            this.mGestureDetector.onTouchEvent(ev);
        }
        return super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mEnabled && this.mScroller != null && this.mScroller.contains(ev.getX(), ev.getY())) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        super.setAdapter(adapter);
        if (this.mScroller != null) {
            this.mScroller.setAdapter(adapter);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mScroller != null) {
            this.mScroller.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public void setIndexTextSize(int value) {
        this.mScroller.setIndexTextSize(value);
    }

    public void setIndexbarWidth(float value) {
        this.mScroller.setIndexbarWidth(value);
    }

    public void setIndexbarMargin(float value) {
        this.mScroller.setIndexbarMargin(value);
    }

    public void setPreviewPadding(int value) {
        this.mScroller.setPreviewPadding(value);
    }

    public void setIndexBarCornerRadius(int value) {
        this.mScroller.setIndexBarCornerRadius(value);
    }

    public void setIndexBarTransparentValue(float value) {
        this.mScroller.setIndexBarTransparentValue(value);
    }

    public void setTypeface(Typeface typeface) {
        this.mScroller.setTypeface(typeface);
    }

    public void setIndexBarVisibility(boolean shown) {
        this.mScroller.setIndexBarVisibility(shown);
        this.mEnabled = shown;
    }

    public void setPreviewVisibility(boolean shown) {
        this.mScroller.setPreviewVisibility(shown);
    }

    public void setIndexBarColor(String color) {
        this.mScroller.setIndexBarColor(Color.parseColor((String)color));
    }

    public void setIndexBarColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexBarColor(colorValue);
    }

    public void setIndexBarTextColor(String color) {
        this.mScroller.setIndexBarTextColor(Color.parseColor((String)color));
    }

    public void setIndexBarTextColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexBarTextColor(colorValue);
    }

    public void setIndexbarHighLateTextColor(String color) {
        this.mScroller.setIndexBarHighLateTextColor(Color.parseColor((String)color));
    }

    public void setIndexbarHighLateTextColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexBarHighLateTextColor(colorValue);
    }

    public void setIndexBarHighLateTextVisibility(boolean shown) {
        this.mScroller.setIndexBarHighLateTextVisibility(shown);
    }
}

