/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.validation;

import com.github.mygreen.supercsv.validation.CsvError;
import java.util.HashMap;
import java.util.Map;

public class CsvFieldError
extends CsvError {
    private static final long serialVersionUID = -7775352881004606689L;
    private final boolean processingFailure;
    private final String field;

    public CsvFieldError(String objectName, String field, boolean processingFailure, String[] codes, Map<String, Object> variables, String defaultMessage) {
        super(objectName, codes, variables, defaultMessage);
        this.processingFailure = processingFailure;
        this.field = field;
    }

    public boolean isProcessingFailure() {
        return this.processingFailure;
    }

    public String getField() {
        return this.field;
    }

    public static final class Builder {
        private final String objectName;
        private final String field;
        private final String[] codes;
        private boolean processingFailure;
        private Map<String, Object> variables = new HashMap<String, Object>();
        private String defaultMessage;

        public Builder(String objectName, String field, String[] codes) {
            this.objectName = objectName;
            this.field = field;
            this.codes = codes;
        }

        public Builder processingFailure(boolean processingFailure) {
            this.processingFailure = processingFailure;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables.putAll(variables);
            return this;
        }

        public Builder variables(String key, Object value) {
            this.variables.put(key, value);
            return this;
        }

        public Builder defaultMessage(String defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public CsvFieldError build() {
            return new CsvFieldError(this.objectName, this.field, this.processingFailure, this.codes, this.variables, this.defaultMessage);
        }
    }
}

