/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.validation;

import com.github.mygreen.supercsv.localization.MessageInterpolator;
import com.github.mygreen.supercsv.localization.MessageResolver;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CsvError
implements Serializable {
    private static final long serialVersionUID = -1561852232153053944L;
    private final String objectName;
    private final String[] codes;
    private final Map<String, Object> variables;
    private final String defaultMessage;

    public CsvError(String objectName, String[] codes, Map<String, Object> variables, String defaultMessaage) {
        this.objectName = objectName;
        this.codes = codes;
        this.variables = variables;
        this.defaultMessage = defaultMessaage;
    }

    public String format(MessageResolver messageResolver, MessageInterpolator messageInterpolator) {
        for (String code : this.getCodes()) {
            Optional<String> message = messageResolver.getMessage(code);
            if (!message.isPresent()) continue;
            return messageInterpolator.interpolate(message.get(), this.getVariables(), true, messageResolver);
        }
        return messageInterpolator.interpolate(this.getDefaultMessage(), this.getVariables(), true, messageResolver);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String[] getCodes() {
        return this.codes;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public static final class Builder {
        private final String objectName;
        private final String[] codes;
        private Map<String, Object> variables = new HashMap<String, Object>();
        private String defaultMessage;

        public Builder(String objectName, String[] codes) {
            this.objectName = objectName;
            this.codes = codes;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables.putAll(variables);
            return this;
        }

        public Builder variables(String key, Object value) {
            this.variables.put(key, value);
            return this;
        }

        public Builder defaultMessage(String defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public CsvError build() {
            return new CsvError(this.objectName, this.codes, this.variables, this.defaultMessage);
        }
    }
}

