/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.util;

import java.util.LinkedList;
import java.util.Objects;

public class StackUtils {
    public static boolean equalsBottomElement(LinkedList<String> stack, String str) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.peekLast().equals(str);
    }

    public static boolean equalsAnyBottomElement(LinkedList<String> stack, String[] strs) {
        Objects.requireNonNull("stack should not be null.");
        Objects.requireNonNull("strs should not be null.");
        if (stack.isEmpty()) {
            return false;
        }
        String bottom = stack.peekLast();
        for (String str : strs) {
            if (!str.equals(bottom)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsTopElement(LinkedList<String> stack, String str) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.peekFirst().equals(str);
    }

    public static boolean equalsAnyTopElement(LinkedList<String> stack, String[] strs) {
        Objects.requireNonNull("stack should not be null.");
        Objects.requireNonNull("strs should not be null.");
        if (stack.isEmpty()) {
            return false;
        }
        String top = stack.peekFirst();
        for (String str : strs) {
            if (!str.equals(top)) continue;
            return true;
        }
        return false;
    }

    public static String popupAndConcat(LinkedList<String> stack) {
        StringBuilder value = new StringBuilder();
        while (!stack.isEmpty()) {
            value.append(stack.pollLast());
        }
        return value.toString();
    }

    public static String popup(LinkedList<String> stack) {
        if (stack.isEmpty()) {
            return "";
        }
        return stack.pollFirst();
    }
}

