/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.localization;

import com.github.mygreen.supercsv.localization.MessageResolver;
import java.util.Optional;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;

public class SpringMessageResolver
implements MessageResolver {
    protected MessageSourceAccessor messageSourceAccessor;

    public SpringMessageResolver() {
    }

    public SpringMessageResolver(MessageSource messageSource) {
        this.setMessageSource(messageSource);
    }

    @Override
    public Optional<String> getMessage(String code) {
        try {
            return Optional.of(this.messageSourceAccessor.getMessage(code));
        }
        catch (NoSuchMessageException e) {
            return Optional.empty();
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    protected MessageSourceAccessor getMessageSourceAccessor() {
        return this.messageSourceAccessor;
    }
}

