/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.localization;

import com.github.mygreen.supercsv.localization.MessageInterpolator;
import com.github.mygreen.supercsv.localization.MessageResolver;
import com.github.mygreen.supercsv.localization.ResourceBundleMessageResolver;
import com.github.mygreen.supercsv.util.ArgUtils;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class MessageBuilder {
    private static final MessageResolver MESSAGE_RESOLVER = new ResourceBundleMessageResolver("com.github.mygreen.supercsv.localization.Messages", false);
    private static final MessageInterpolator MESSAGE_INTERPOLATOR = new MessageInterpolator();
    private final String code;
    private Map<String, Object> vars = new HashMap<String, Object>();

    public MessageBuilder(String code) {
        ArgUtils.notEmpty(code, "code");
        this.code = code;
    }

    public MessageBuilder var(String key, Object value) {
        this.vars.put(key, value);
        return this;
    }

    public MessageBuilder varWithAnno(String key, Class<? extends Annotation> annoClass) {
        return this.var(key, "@" + annoClass.getSimpleName());
    }

    public MessageBuilder varWithClass(String key, Class<?> clazz) {
        String className;
        if (clazz.isArray()) {
            Class<?> elementType = clazz.getComponentType();
            className = elementType.getName() + "[]";
        } else {
            className = clazz.getName();
        }
        return this.var(key, className);
    }

    public String format() {
        return this.format(false);
    }

    public String format(boolean recusrsive) {
        String message = MESSAGE_RESOLVER.getMessage(this.code).orElseThrow(() -> new IllegalStateException(String.format("not found message key=%s", this.code)));
        return MESSAGE_INTERPOLATOR.interpolate(message, this.vars, recusrsive, MESSAGE_RESOLVER);
    }

    public static MessageBuilder create(String code) {
        return new MessageBuilder(code);
    }
}

