/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.io;

import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.BeanMappingFactory;
import com.github.mygreen.supercsv.exception.SuperCsvBindingException;
import com.github.mygreen.supercsv.io.AbstractCsvAnnotationBeanWriter;
import com.github.mygreen.supercsv.io.BeanMappingCache;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Objects;
import org.supercsv.prefs.CsvPreference;

public class CsvAnnotationBeanWriter<T>
extends AbstractCsvAnnotationBeanWriter<T> {
    public CsvAnnotationBeanWriter(Class<T> beanType, Writer writer, CsvPreference preference, Class<?> ... groups) {
        super(writer, preference);
        Objects.requireNonNull(beanType, "beanType should not be null.");
        BeanMappingFactory factory = new BeanMappingFactory();
        this.beanMappingCache = BeanMappingCache.create(factory.create(beanType, groups));
        this.validators.addAll(this.beanMappingCache.getOriginal().getValidators());
    }

    public CsvAnnotationBeanWriter(BeanMapping<T> beanMapping, Writer writer, CsvPreference preference) {
        super(writer, preference);
        Objects.requireNonNull(beanMapping, "beanMapping should not be null.");
        this.beanMappingCache = BeanMappingCache.create(beanMapping);
        this.validators.addAll(beanMapping.getValidators());
    }

    public void writeHeader() throws IOException {
        super.writeHeader(this.getDefinedHeader());
    }

    public void writeAll(Collection<T> sources) throws IOException {
        this.writeAll(sources, false);
    }

    public void writeAll(Collection<T> sources, boolean continueOnError) throws IOException {
        Objects.requireNonNull(sources, "sources should not be null.");
        if (this.beanMappingCache.getOriginal().isHeader() && this.getLineNumber() == 0) {
            this.writeHeader();
        }
        for (T record : sources) {
            try {
                this.write(record);
            }
            catch (SuperCsvBindingException e) {
                if (continueOnError) continue;
                throw e;
            }
        }
        super.flush();
    }
}

