/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.io;

import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.CallbackMethod;
import com.github.mygreen.supercsv.exception.SuperCsvBindingException;
import com.github.mygreen.supercsv.exception.SuperCsvRowException;
import com.github.mygreen.supercsv.io.BeanMappingCache;
import com.github.mygreen.supercsv.validation.CsvBindingErrors;
import com.github.mygreen.supercsv.validation.CsvError;
import com.github.mygreen.supercsv.validation.CsvExceptionConverter;
import com.github.mygreen.supercsv.validation.CsvValidator;
import com.github.mygreen.supercsv.validation.ValidationContext;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.exception.SuperCsvReflectionException;
import org.supercsv.io.AbstractCsvWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;
import org.supercsv.util.MethodCache;

public abstract class AbstractCsvAnnotationBeanWriter<T>
extends AbstractCsvWriter {
    protected BeanMappingCache<T> beanMappingCache;
    protected final List<Object> beanValues = new ArrayList<Object>();
    protected final List<Object> processedColumns = new ArrayList<Object>();
    protected final MethodCache cache = new MethodCache();
    protected CsvExceptionConverter exceptionConverter = new CsvExceptionConverter();
    protected final List<String> errorMessages = new ArrayList<String>();
    protected final List<CsvValidator<T>> validators = new ArrayList<CsvValidator<T>>();

    public AbstractCsvAnnotationBeanWriter(Writer writer, CsvPreference preference) {
        super(writer, preference);
    }

    public void write(T source) throws IOException {
        Objects.requireNonNull(source, "the bean to write should not be null.");
        super.incrementRowAndLineNo();
        CsvContext context = new CsvContext(this.getLineNumber(), this.getRowNumber(), 1);
        context.setRowSource(Collections.emptyList());
        CsvBindingErrors bindingErrors = new CsvBindingErrors(this.beanMappingCache.getOriginal().getType());
        for (CallbackMethod callback : this.beanMappingCache.getOriginal().getPreWriteMethods()) {
            callback.invoke(source, context, bindingErrors, this.beanMappingCache.getOriginal());
        }
        this.extractBeanValues(source, this.beanMappingCache.getNameMapping());
        context.setRowSource(new ArrayList<Object>(this.beanValues));
        Optional<SuperCsvRowException> rowException = Optional.empty();
        try {
            this.executeCellProcessors(this.processedColumns, this.beanValues, this.beanMappingCache.getCellProcessorsForWriting(), context);
        }
        catch (SuperCsvRowException e) {
            rowException = Optional.of(e);
            List<CsvError> errors = this.exceptionConverter.convert((SuperCsvException)e, this.beanMappingCache.getOriginal());
            bindingErrors.addAllErrors(errors);
        }
        catch (SuperCsvException e) {
            this.errorMessages.addAll(this.exceptionConverter.convertAndFormat(e, this.beanMappingCache.getOriginal()));
            throw e;
        }
        if (!this.beanMappingCache.getOriginal().isSkipValidationOnWrite()) {
            for (CsvValidator<T> validator : this.validators) {
                validator.validate(source, bindingErrors, new ValidationContext<T>(context, this.beanMappingCache.getOriginal()));
            }
        }
        this.processErrors(bindingErrors, context, rowException);
        super.writeRow(this.processedColumns);
        for (CallbackMethod callback : this.beanMappingCache.getOriginal().getPostWriteMethods()) {
            callback.invoke(source, context, bindingErrors, this.beanMappingCache.getOriginal());
        }
        this.processErrors(bindingErrors, context, rowException);
    }

    protected void processErrors(CsvBindingErrors bindingErrors, CsvContext context, Optional<SuperCsvRowException> rowException) {
        if (bindingErrors.hasErrors()) {
            List message = bindingErrors.getAllErrors().stream().map(error -> error.format(this.exceptionConverter.getMessageResolver(), this.exceptionConverter.getMessageInterpolator())).collect(Collectors.toList());
            this.errorMessages.addAll(message);
            SuperCsvBindingException bindingException = new SuperCsvBindingException("has binding error.", context, bindingErrors);
            rowException.ifPresent(re -> bindingException.addAllProcessingErrors(re.getColumnErrors()));
            throw bindingException;
        }
    }

    protected void extractBeanValues(Object source, String[] nameMapping) throws SuperCsvReflectionException {
        Objects.requireNonNull(nameMapping, "the nameMapping array can't be null as it's used to map from fields to columns");
        this.beanValues.clear();
        for (int i = 0; i < nameMapping.length; ++i) {
            String fieldName = nameMapping[i];
            if (fieldName == null) {
                this.beanValues.add(null);
                continue;
            }
            Method getMethod = this.cache.getGetMethod(source, fieldName);
            try {
                this.beanValues.add(getMethod.invoke(source, new Object[0]));
                continue;
            }
            catch (Exception e) {
                throw new SuperCsvReflectionException(String.format("error extracting bean value for field %s", fieldName), (Throwable)e);
            }
        }
    }

    protected void executeCellProcessors(List<Object> destination, List<?> source, CellProcessor[] processors, CsvContext context) {
        destination.clear();
        SuperCsvRowException rowException = new SuperCsvRowException(String.format("row (%d) has errors column", context.getRowNumber()), context);
        for (int i = 0; i < source.size(); ++i) {
            try {
                context.setColumnNumber(i + 1);
                if (processors[i] == null) {
                    destination.add(source.get(i));
                    continue;
                }
                destination.add(processors[i].execute(source.get(i), context));
                continue;
            }
            catch (SuperCsvCellProcessorException e) {
                rowException.addError(e);
                destination.add(source.get(i));
                continue;
            }
            catch (SuperCsvException e) {
                throw e;
            }
        }
        if (rowException.isNotEmptyColumnErrors()) {
            throw rowException;
        }
    }

    public String[] getDefinedHeader() {
        return this.beanMappingCache.getHeader();
    }

    public BeanMapping<T> getBeanMapping() {
        return this.beanMappingCache.getOriginal();
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public CsvExceptionConverter getExceptionConverter() {
        return this.exceptionConverter;
    }

    public void setExceptionConverter(CsvExceptionConverter exceptionConverter) {
        this.exceptionConverter = exceptionConverter;
    }

    public void addValidator(CsvValidator<T> ... validators) {
        this.validators.addAll(Arrays.asList(validators));
    }

    public List<CsvValidator<T>> getValidators() {
        return this.validators;
    }
}

