/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.expression;

import com.github.mygreen.supercsv.expression.ExpressionEvaluationException;
import com.github.mygreen.supercsv.expression.ExpressionLanguage;
import com.github.mygreen.supercsv.expression.ObjectCache;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionLanguageJEXLImpl
implements ExpressionLanguage {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionLanguageJEXLImpl.class);
    private final JexlEngine jexlEngine;
    private final ObjectCache<String, Expression> expressionCache = new ObjectCache();

    public ExpressionLanguageJEXLImpl() {
        this(new JexlEngine());
    }

    public ExpressionLanguageJEXLImpl(JexlEngine jexlEngine) {
        this.jexlEngine = jexlEngine;
    }

    @Override
    public Object evaluate(String expression, Map<String, Object> values) {
        Objects.requireNonNull(expression, "expression shoud not be null.");
        Objects.requireNonNull(values, "values shoud not be null.");
        if (logger.isDebugEnabled()) {
            logger.debug("Evaluating JEXL expression: {}", (Object)expression);
        }
        try {
            Expression expr = this.expressionCache.get(expression);
            if (expr == null) {
                expr = this.jexlEngine.createExpression(expression);
                this.expressionCache.put(expression, expr);
            }
            return expr.evaluate((JexlContext)new MapContext(values));
        }
        catch (Exception ex) {
            throw new ExpressionEvaluationException(String.format("Evaluating [%s] script with JEXL failed.", expression), (Throwable)ex, expression, values);
        }
    }

    public JexlEngine getJexlEngine() {
        return this.jexlEngine;
    }
}

