/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.expression;

import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class CustomFunctions {
    public static String defaultString(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    public static String join(int[] array, String delimiter) {
        if (array == null || array.length == 0) {
            return "";
        }
        String value = Arrays.stream(array).boxed().map(String::valueOf).collect(Collectors.joining(CustomFunctions.defaultString(delimiter)));
        return value;
    }

    public static String join(Object[] array, String delimiter) {
        if (array == null || array.length == 0) {
            return "";
        }
        String value = Arrays.stream(array).map(v -> v.toString()).collect(Collectors.joining(CustomFunctions.defaultString(delimiter)));
        return value;
    }

    public static String join(Object[] array, String delimiter, TextPrinter printer) {
        Objects.requireNonNull(printer);
        if (array == null || array.length == 0) {
            return "";
        }
        String value = Arrays.stream(array).map(v -> printer.print(v)).collect(Collectors.joining(CustomFunctions.defaultString(delimiter)));
        return value;
    }

    public static String join(Collection<?> collection, String delimiter) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        String value = collection.stream().map(v -> v.toString()).collect(Collectors.joining(CustomFunctions.defaultString(delimiter)));
        return value;
    }

    public static String join(Collection<?> collection, String delimiter, TextPrinter printer) {
        Objects.requireNonNull(printer);
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        String value = collection.stream().map(v -> printer.print(v)).collect(Collectors.joining(CustomFunctions.defaultString(delimiter)));
        return value;
    }
}

