/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.exception;

import org.supercsv.exception.SuperCsvException;
import org.supercsv.util.CsvContext;

public class SuperCsvNoMatchColumnSizeException
extends SuperCsvException {
    private static final long serialVersionUID = 1L;
    protected final int actualColumnSize;
    protected final int epxpectedColumnSize;

    public SuperCsvNoMatchColumnSizeException(int actualColumnSize, int epxpectedColumnSize, CsvContext context) {
        this("", actualColumnSize, epxpectedColumnSize, context);
    }

    public SuperCsvNoMatchColumnSizeException(String message, int actualColumnSize, int epxpectedColumnSize, CsvContext context) {
        super(message + String.format("The number of columns to be processed (%d) must match the number of CellProcessors (%d): check that the number of CellProcessors you have defined matches the expected number of columns being read/written", actualColumnSize, epxpectedColumnSize), context);
        this.actualColumnSize = actualColumnSize;
        this.epxpectedColumnSize = epxpectedColumnSize;
    }

    public int getActualColumnSize() {
        return this.actualColumnSize;
    }

    public int getEpxpectedColumnSize() {
        return this.epxpectedColumnSize;
    }
}

