/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrintException;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class PrintProcessor<T>
extends ValidationCellProcessor
implements BoolCellProcessor,
DateCellProcessor,
DoubleCellProcessor,
LongCellProcessor,
StringCellProcessor {
    private final TextPrinter<T> printer;

    public PrintProcessor(TextPrinter<T> printer) {
        PrintProcessor.checkPreconditions(printer);
        this.printer = printer;
    }

    public PrintProcessor(TextPrinter<T> printer, StringCellProcessor next) {
        super((CellProcessor)next);
        PrintProcessor.checkPreconditions(printer);
        this.printer = printer;
    }

    private static <T> void checkPreconditions(TextPrinter<T> printer) {
        if (printer == null) {
            throw new NullPointerException("printer is null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        try {
            String result = this.printer.print(value);
            return this.next.execute((Object)result, context);
        }
        catch (TextPrintException e) {
            throw this.createValidationException(context).messageFormat("'%s' could not print.", value.toString()).exception(e).rejectedValue(value).build();
        }
    }
}

