/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.cellprocessor.conversion.CharReplacer;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class WordReplace
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final CharReplacer replacer;

    public WordReplace(CharReplacer replacer) {
        WordReplace.checkPreconditions(replacer);
        this.replacer = replacer;
    }

    public WordReplace(CharReplacer replacer, StringCellProcessor next) {
        super((CellProcessor)next);
        WordReplace.checkPreconditions(replacer);
        this.replacer = replacer;
    }

    private static void checkPreconditions(CharReplacer replacer) {
        if (replacer == null) {
            throw new NullPointerException("replacer should not be null.");
        }
    }

    public <T> T execute(Object value, CsvContext context) {
        if (value == null) {
            return (T)this.next.execute(value, context);
        }
        String result = this.replacer.replace(value.toString());
        return (T)this.next.execute((Object)result, context);
    }
}

