/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.annotation.conversion.CsvRegexReplace;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConversionProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.RegexReplace;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import com.github.mygreen.supercsv.util.Utils;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;

public class RegexReplaceFactory
implements ConversionProcessorFactory<CsvRegexReplace> {
    @Override
    public Optional<CellProcessor> create(CsvRegexReplace anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        Pattern pattern;
        int flags = Utils.buildRegexFlags(anno.flags());
        try {
            pattern = Pattern.compile(anno.regex(), flags);
        }
        catch (PatternSyntaxException e) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "regex").var("attrValue", anno.regex()).var("type", "{key.regex}").format(true));
        }
        String replacement = anno.replacement();
        boolean partialMatched = anno.partialMatched();
        RegexReplace processor = next.map(n -> new RegexReplace(pattern, replacement, partialMatched, (StringCellProcessor)n)).orElseGet(() -> new RegexReplace(pattern, replacement, partialMatched));
        return Optional.of(processor);
    }
}

