/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class RegexReplace
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final Pattern pattern;
    private final String replacement;
    private final boolean partialMatched;

    public RegexReplace(Pattern pattern, String replacement, boolean partialMatched) {
        RegexReplace.checkPreconditions(pattern, replacement);
        this.pattern = pattern;
        this.replacement = replacement;
        this.partialMatched = partialMatched;
    }

    public RegexReplace(Pattern pattern, String replacement, boolean partialMatched, StringCellProcessor next) {
        super((CellProcessor)next);
        RegexReplace.checkPreconditions(pattern, replacement);
        this.pattern = pattern;
        this.replacement = replacement;
        this.partialMatched = partialMatched;
    }

    private static void checkPreconditions(Pattern pattern, String replacement) {
        if (pattern == null) {
            throw new NullPointerException("regex should not be null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement should not be null");
        }
    }

    public <T> T execute(Object value, CsvContext context) {
        boolean matched;
        if (value == null) {
            return (T)this.next.execute(value, context);
        }
        Matcher matcher = this.pattern.matcher(value.toString());
        boolean bl = matched = this.partialMatched ? matcher.find() : matcher.matches();
        if (matched) {
            String result = matcher.replaceAll(this.replacement);
            return (T)this.next.execute((Object)result, context);
        }
        return (T)this.next.execute(value, context);
    }

    public String getRegex() {
        return this.pattern.toString();
    }

    public int getFlags() {
        return this.pattern.flags();
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean isPartialMatched() {
        return this.partialMatched;
    }
}

