/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.annotation.conversion.CsvMultiPad;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConversionProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.MultiPad;
import com.github.mygreen.supercsv.cellprocessor.conversion.PaddingProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;

public class MultiPadFactory
implements ConversionProcessorFactory<CsvMultiPad> {
    @Override
    public Optional<CellProcessor> create(CsvMultiPad anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        if (anno.size() <= 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.min").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "size").var("attrValue", anno.size()).var("min", 1).format());
        }
        PaddingProcessor paddingProcessor = (PaddingProcessor)config.getBeanFactory().create(anno.paddingProcessor());
        MultiPad processor = next.map(n -> new MultiPad(anno.size(), anno.padChar(), anno.rightAlign(), anno.chopped(), paddingProcessor, (StringCellProcessor)n)).orElseGet(() -> new MultiPad(anno.size(), anno.padChar(), anno.rightAlign(), anno.chopped(), paddingProcessor));
        return Optional.of(processor);
    }
}

