/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.cellprocessor.conversion.CharCategory;
import com.github.mygreen.supercsv.cellprocessor.conversion.CharReplacer;
import com.github.mygreen.supercsv.util.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class JapaneseCharReplacer {
    private static final Map<CharCategory, String[][]> CHAR_MAPS;
    private final CharReplacer fullCharReplacer = new CharReplacer();
    private final CharReplacer halfCharReplacer = new CharReplacer();

    public JapaneseCharReplacer(Collection<CharCategory> categories) {
        HashSet<CharCategory> categorySet = new HashSet<CharCategory>(categories);
        for (CharCategory category : categorySet) {
            String[][] charMap;
            for (String[] map : charMap = CHAR_MAPS.get((Object)category)) {
                this.fullCharReplacer.register(map[0], map[1]);
                this.halfCharReplacer.register(map[1], map[0]);
            }
        }
        this.fullCharReplacer.ready();
        this.halfCharReplacer.ready();
    }

    public JapaneseCharReplacer(CharCategory ... categories) {
        this(Arrays.asList(categories));
    }

    public String replaceToFullChar(String text) {
        if (Utils.isEmpty(text)) {
            return text;
        }
        return this.fullCharReplacer.replace(text);
    }

    public String replaceToHalfChar(String text) {
        if (Utils.isEmpty(text)) {
            return text;
        }
        return this.halfCharReplacer.replace(text);
    }

    static {
        HashMap<CharCategory, String[][]> map = new HashMap<CharCategory, String[][]>();
        map.put(CharCategory.Number, new String[][]{{"0", "\uff10"}, {"1", "\uff11"}, {"2", "\uff12"}, {"3", "\uff13"}, {"4", "\uff14"}, {"5", "\uff15"}, {"6", "\uff16"}, {"7", "\uff17"}, {"8", "\uff18"}, {"9", "\uff19"}});
        map.put(CharCategory.Alpha, new String[][]{{"a", "\uff41"}, {"b", "\uff42"}, {"c", "\uff43"}, {"d", "\uff44"}, {"e", "\uff45"}, {"f", "\uff46"}, {"g", "\uff47"}, {"h", "\uff48"}, {"i", "\uff49"}, {"j", "\uff4a"}, {"k", "\uff4b"}, {"l", "\uff4c"}, {"m", "\uff4d"}, {"n", "\uff4e"}, {"o", "\uff4f"}, {"p", "\uff50"}, {"q", "\uff51"}, {"r", "\uff52"}, {"s", "\uff53"}, {"t", "\uff54"}, {"u", "\uff55"}, {"v", "\uff56"}, {"w", "\uff57"}, {"x", "\uff58"}, {"y", "\uff59"}, {"z", "\uff5a"}, {"A", "\uff21"}, {"B", "\uff22"}, {"C", "\uff23"}, {"D", "\uff24"}, {"E", "\uff25"}, {"F", "\uff26"}, {"G", "\uff27"}, {"H", "\uff28"}, {"I", "\uff29"}, {"J", "\uff2a"}, {"K", "\uff2b"}, {"L", "\uff2c"}, {"M", "\uff2d"}, {"N", "\uff2e"}, {"O", "\uff2f"}, {"P", "\uff30"}, {"Q", "\uff31"}, {"R", "\uff32"}, {"S", "\uff33"}, {"T", "\uff34"}, {"U", "\uff35"}, {"V", "\uff36"}, {"W", "\uff37"}, {"X", "\uff38"}, {"Y", "\uff39"}, {"Z", "\uff3a"}});
        map.put(CharCategory.Space, new String[][]{{" ", "\u3000"}});
        map.put(CharCategory.Symbol, new String[][]{{"!", "\uff01"}, {"\"", "\u201d"}, {"#", "\uff03"}, {"$", "\uff04"}, {"%", "\uff05"}, {"&", "\uff06"}, {"'", "\u2019"}, {"(", "\uff08"}, {")", "\uff09"}, {"=", "\uff1d"}, {"^", "\uff3e"}, {"~", "\uff5e"}, {"|", "\uff5c"}, {"\\", "\uffe5"}, {"`", "\u2018"}, {"@", "\uff20"}, {"[", "\uff3b"}, {"]", "\uff3d"}, {"{", "\uff5b"}, {"}", "\uff5d"}, {"+", "\uff0b"}, {"-", "\u30fc"}, {";", "\uff1b"}, {":", "\uff1a"}, {"*", "\uff0a"}, {"<", "\uff1c"}, {">", "\uff1e"}, {",", "\uff0c"}, {".", "\uff0e"}, {"?", "\uff1f"}, {"/", "\uff0f"}, {"_", "\uff3f"}});
        map.put(CharCategory.Katakana, new String[][]{{"\uff71", "\u30a2"}, {"\uff72", "\u30a4"}, {"\uff73", "\u30a6"}, {"\uff74", "\u30a8"}, {"\uff75", "\u30aa"}, {"\uff76", "\u30ab"}, {"\uff77", "\u30ad"}, {"\uff78", "\u30af"}, {"\uff79", "\u30b1"}, {"\uff7a", "\u30b3"}, {"\uff7b", "\u30b5"}, {"\uff7c", "\u30b7"}, {"\uff7d", "\u30b9"}, {"\uff7e", "\u30bb"}, {"\uff7f", "\u30bd"}, {"\uff80", "\u30bf"}, {"\uff81", "\u30c1"}, {"\uff82", "\u30c4"}, {"\uff83", "\u30c6"}, {"\uff84", "\u30c8"}, {"\uff85", "\u30ca"}, {"\uff86", "\u30cb"}, {"\uff87", "\u30cc"}, {"\uff88", "\u30cd"}, {"\uff89", "\u30ce"}, {"\uff8a", "\u30cf"}, {"\uff8b", "\u30d2"}, {"\uff8c", "\u30d5"}, {"\uff8d", "\u30d8"}, {"\uff8e", "\u30db"}, {"\uff8f", "\u30de"}, {"\uff90", "\u30df"}, {"\uff91", "\u30e0"}, {"\uff92", "\u30e1"}, {"\uff93", "\u30e2"}, {"\uff94", "\u30e4"}, {"\uff95", "\u30e6"}, {"\uff96", "\u30e8"}, {"\uff97", "\u30e9"}, {"\uff98", "\u30ea"}, {"\uff99", "\u30eb"}, {"\uff9a", "\u30ec"}, {"\uff9b", "\u30ed"}, {"\uff9c", "\u30ef"}, {"\uff66", "\u30f2"}, {"\uff9d", "\u30f3"}, {"\uff73\uff9e", "\u30f4"}, {"\uff8a\uff9f", "\u30d1"}, {"\uff8b\uff9f", "\u30d4"}, {"\uff8c\uff9f", "\u30d7"}, {"\uff8d\uff9f", "\u30da"}, {"\uff8e\uff9f", "\u30dd"}, {"\uff8a\uff9e", "\u30d0"}, {"\uff8b\uff9e", "\u30d3"}, {"\uff8c\uff9e", "\u30d6"}, {"\uff8d\uff9e", "\u30d9"}, {"\uff8e\uff9e", "\u30dc"}, {"\uff67", "\u30a1"}, {"\uff68", "\u30a3"}, {"\uff69", "\u30a5"}, {"\uff6a", "\u30a7"}, {"\uff6b", "\u30a9"}, {"\uff6f", "\u30c3"}});
        CHAR_MAPS = Collections.unmodifiableMap(map);
    }
}

