/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.cellprocessor.conversion.AbstractPaddingOperator;
import com.github.mygreen.supercsv.util.ArgUtils;

public class CharWidthPaddingProcessor
extends AbstractPaddingOperator {
    @Override
    public int count(int codePoint) {
        if (Character.charCount(codePoint) >= 2) {
            return 2;
        }
        char c = (char)codePoint;
        if (c <= '~' || c == '\u00a5' || c == '\u203e' || c >= '\uff61' && c <= '\uff9f') {
            return 1;
        }
        return 2;
    }

    @Override
    public int count(String text) {
        ArgUtils.notNull(text, "text");
        int count = 0;
        int length = text.length();
        int codePoint = 0;
        for (int i = 0; i < length; i += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(i);
            count += this.count(codePoint);
        }
        return count;
    }
}

