/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.cellprocessor.conversion.PaddingProcessor;

public abstract class AbstractPaddingOperator
implements PaddingProcessor {
    private int[] toCodePointArray(String text) {
        int length = text.length();
        int codePointLength = text.codePointCount(0, length);
        int[] array = new int[codePointLength];
        int j = 0;
        int codePoint = 0;
        for (int i = 0; i < length; i += Character.charCount(codePoint)) {
            array[j] = codePoint = text.codePointAt(i);
            ++j;
        }
        return array;
    }

    @Override
    public String pad(String text, int size, char padChar, boolean rightAlign, boolean chopped) {
        int currentSize = this.count(text);
        int padCharSize = this.count(String.valueOf(padChar));
        int[] codePointArray = this.toCodePointArray(text);
        int codePointSize = codePointArray.length;
        if (rightAlign) {
            if (currentSize == size) {
                return text;
            }
            if (currentSize > size) {
                if (chopped) {
                    int overLength = currentSize - size;
                    int chopLength = 0;
                    for (int i = 0; i < codePointSize; ++i) {
                        int codePoint = codePointArray[i];
                        if ((chopLength += this.count(codePoint)) < overLength) continue;
                        String chopText = new String(codePointArray, i + 1, codePointSize - (i + 1));
                        return this.pad(chopText, size, padChar, rightAlign, chopped);
                    }
                    return "";
                }
                return text;
            }
            int lackLength = size - currentSize;
            int padCount = lackLength / padCharSize;
            StringBuilder appender = new StringBuilder();
            for (int i = 0; i < padCount; ++i) {
                appender.append(padChar);
            }
            appender.append(text);
            return appender.toString();
        }
        if (currentSize == size) {
            return text;
        }
        if (currentSize > size) {
            if (chopped) {
                int overLength = currentSize - size;
                int chopLength = 0;
                for (int i = codePointSize - 1; i >= 0; --i) {
                    int codePoint = codePointArray[i];
                    if ((chopLength += this.count(codePoint)) < overLength) continue;
                    String chopText = new String(codePointArray, 0, i);
                    return this.pad(chopText, size, padChar, rightAlign, chopped);
                }
                return "";
            }
            return text;
        }
        int lackLength = size - currentSize;
        int padCount = lackLength / padCharSize;
        StringBuilder appender = new StringBuilder(text);
        for (int i = 0; i < padCount; ++i) {
            appender.append(padChar);
        }
        return appender.toString();
    }

    protected abstract int count(int var1);

    protected abstract int count(String var1);
}

