/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.util.CsvContext;

public class Unique<T>
extends ValidationCellProcessor {
    private final Map<T, ValueObject> encounteredElements = new HashMap<T, ValueObject>();
    private final TextPrinter<T> printer;

    public Unique(TextPrinter<T> printer) {
        Unique.checkPreconditions(printer);
        this.printer = printer;
    }

    public Unique(TextPrinter<T> printer, CellProcessor next) {
        super(next);
        Unique.checkPreconditions(printer);
        this.printer = printer;
    }

    private static <T> void checkPreconditions(TextPrinter<T> printer) {
        if (printer == null) {
            throw new NullPointerException("printer should not be null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        Object result = value;
        if (this.encounteredElements.containsKey(result)) {
            String formattedValue = this.printer.print(result);
            ValueObject duplicatedObject = this.encounteredElements.get(result);
            throw this.createValidationException(context).messageFormat("duplicate value '%s' encountered.", formattedValue).rejectedValue(result).messageVariables("duplicatedLineNumber", duplicatedObject.lineNumber).messageVariables("duplicatedRowNumber", duplicatedObject.rowNumber).messageVariables("printer", this.getPrinter()).build();
        }
        ValueObject object = new ValueObject(result, context.getLineNumber(), context.getRowNumber());
        this.encounteredElements.put(object.value, object);
        return this.next.execute(value, context);
    }

    public TextPrinter<T> getPrinter() {
        return this.printer;
    }

    private class ValueObject {
        final T value;
        final int lineNumber;
        final int rowNumber;

        ValueObject(T value, int lineNumber, int rowNumber) {
            this.value = value;
            this.lineNumber = lineNumber;
            this.rowNumber = rowNumber;
        }
    }
}

