/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvPattern;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.Pattern;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import com.github.mygreen.supercsv.util.Utils;
import java.util.Optional;
import java.util.regex.PatternSyntaxException;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;

public class PatternFactory
implements ConstraintProcessorFactory<CsvPattern> {
    @Override
    public Optional<CellProcessor> create(CsvPattern anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        java.util.regex.Pattern pattern;
        int flags = Utils.buildRegexFlags(anno.flags());
        try {
            pattern = java.util.regex.Pattern.compile(anno.regex(), flags);
        }
        catch (PatternSyntaxException e) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "regex").var("attrValue", anno.regex()).var("type", "{key.regex}").format(true));
        }
        Pattern processor = next.map(n -> new Pattern(pattern, anno.description(), (StringCellProcessor)n)).orElseGet(() -> new Pattern(pattern, anno.description()));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

