/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class NumberMin<T extends Number>
extends ValidationCellProcessor
implements LongCellProcessor,
DoubleCellProcessor {
    private final T min;
    private final boolean inclusive;
    private final TextPrinter<T> printer;

    public NumberMin(T min, boolean inclusive, TextPrinter<T> printer) {
        NumberMin.checkPreconditions(min, printer);
        this.min = min;
        this.inclusive = inclusive;
        this.printer = printer;
    }

    public NumberMin(T min, boolean inclusive, TextPrinter<T> printer, CellProcessor next) {
        super(next);
        NumberMin.checkPreconditions(min, printer);
        this.min = min;
        this.inclusive = inclusive;
        this.printer = printer;
    }

    private static <T extends Number> void checkPreconditions(T min, TextPrinter<T> printer) {
        if (min == null || printer == null) {
            throw new NullPointerException("min and printer should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        Class<?> exepectedClass = this.getMin().getClass();
        if (!exepectedClass.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(exepectedClass, value, context, (CellProcessor)this);
        }
        Number result = (Number)value;
        if (!this.validate(result)) {
            throw this.createValidationException(context).messageFormat("%s does not lie the min (%s) value.", this.printValue(result), this.printValue(this.min)).rejectedValue(result).messageVariables("min", this.getMin()).messageVariables("inclusive", this.isInclusive()).messageVariables("printer", this.getPrinter()).build();
        }
        return this.next.execute((Object)result, context);
    }

    private boolean validate(T value) {
        int compared = ((Comparable)value).compareTo(this.min);
        if (compared > 0) {
            return true;
        }
        return this.inclusive && compared == 0;
    }

    private String printValue(T value) {
        return this.getPrinter().print(value);
    }

    public T getMin() {
        return this.min;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public TextPrinter<T> getPrinter() {
        return this.printer;
    }
}

