/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvNumberMax;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.NumberMax;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class NumberMaxFactory<N extends Number>
implements ConstraintProcessorFactory<CsvNumberMax> {
    @Override
    public Optional<CellProcessor> create(CsvNumberMax anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        Number max;
        TextFormatter<?> typeFormatter = formatter;
        try {
            max = (Number)typeFormatter.parse(anno.value());
        }
        catch (TextParseException e) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value").var("attrValue", anno.value()).varWithClass("type", field.getType()).var("pattern", typeFormatter.getPattern().orElseGet(null)).format(true), e);
        }
        NumberMax processor = next.map(n -> new NumberMax<Number>(max, anno.inclusive(), (TextPrinter<Number>)typeFormatter, (CellProcessor)n)).orElseGet(() -> new NumberMax<Number>(max, anno.inclusive(), typeFormatter));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

