/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class NumberMax<T extends Number>
extends ValidationCellProcessor
implements LongCellProcessor,
DoubleCellProcessor {
    private final T max;
    private final boolean inclusive;
    private final TextPrinter<T> printer;

    public NumberMax(T max, boolean inclusive, TextPrinter<T> printer) {
        NumberMax.checkPreconditions(max, printer);
        this.max = max;
        this.inclusive = inclusive;
        this.printer = printer;
    }

    public NumberMax(T max, boolean inclusive, TextPrinter<T> printer, CellProcessor next) {
        super(next);
        NumberMax.checkPreconditions(max, printer);
        this.max = max;
        this.inclusive = inclusive;
        this.printer = printer;
    }

    private static <T extends Number> void checkPreconditions(T max, TextPrinter<T> printer) {
        if (max == null || printer == null) {
            throw new NullPointerException("max and printer should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        Class<?> exepectedClass = this.getMax().getClass();
        if (!exepectedClass.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(exepectedClass, value, context, (CellProcessor)this);
        }
        Number result = (Number)value;
        if (!this.validate(result)) {
            throw this.createValidationException(context).messageFormat("%s does not lie the max (%s) value.", this.printValue(result), this.printValue(this.max)).rejectedValue(result).messageVariables("max", this.getMax()).messageVariables("inclusive", this.isInclusive()).messageVariables("printer", this.getPrinter()).build();
        }
        return this.next.execute((Object)result, context);
    }

    private boolean validate(T value) {
        int compared = ((Comparable)value).compareTo(this.max);
        if (compared < 0) {
            return true;
        }
        return this.inclusive && compared == 0;
    }

    private String printValue(T value) {
        return this.getPrinter().print(value);
    }

    public T getMax() {
        return this.max;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public TextPrinter<T> getPrinter() {
        return this.printer;
    }
}

