/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class LengthBetween
extends ValidationCellProcessor
implements StringCellProcessor {
    private final int min;
    private final int max;

    public LengthBetween(int min, int max) {
        LengthBetween.checkPreconditions(min, max);
        this.min = min;
        this.max = max;
    }

    public LengthBetween(int min, int max, CellProcessor next) {
        super(next);
        LengthBetween.checkPreconditions(min, max);
        this.min = min;
        this.max = max;
    }

    private static void checkPreconditions(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("max (%d) should not be < min (%d)", max, min));
        }
        if (min < 0) {
            throw new IllegalArgumentException(String.format("min length (%d) should not be < 0", min));
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        String stringValue = value.toString();
        int length = stringValue.length();
        if (length < this.min || length > this.max) {
            throw this.createValidationException(context).messageFormat("the length (%d) of value '%s' does not lie between the min (%d) and max (%d) values (inclusive)", length, stringValue, this.min, this.max).rejectedValue(stringValue).messageVariables("min", this.getMin()).messageVariables("max", this.getMax()).messageVariables("length", length).build();
        }
        return this.next.execute((Object)stringValue, context);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

