/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvEquals;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.EqualedValueProvider;
import com.github.mygreen.supercsv.cellprocessor.constraint.Equals;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.ArrayList;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class EqualsFactory<T>
implements ConstraintProcessorFactory<CsvEquals> {
    @Override
    public Optional<CellProcessor> create(CsvEquals anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        TextFormatter<?> typeFormatter = formatter;
        ArrayList equaledValues = new ArrayList();
        if (anno.value().length > 0) {
            for (String str : anno.value()) {
                try {
                    equaledValues.add(typeFormatter.parse(str));
                }
                catch (TextParseException e) {
                    throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value").var("attrValue", str).varWithClass("type", field.getType()).var("pattern", typeFormatter.getPattern().orElseGet(null)).format(), e);
                }
            }
        }
        if (anno.provider().length > 0) {
            EqualedValueProvider provider = (EqualedValueProvider)config.getBeanFactory().create(anno.provider()[0]);
            equaledValues.addAll(provider.getEqualedValues(field));
        }
        if (anno.value().length == 0 && anno.provider().length == 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.required").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value or provider").format());
        }
        Class<?> fieldType = field.getType();
        Equals processor = next.map(n -> new Equals(fieldType, equaledValues, typeFormatter, (CellProcessor)n)).orElseGet(() -> new Equals(fieldType, equaledValues, typeFormatter));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

