/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import java.util.Collection;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class Equals<T>
extends ValidationCellProcessor {
    private final Class<T> type;
    private final Collection<T> equaledValues;
    private final TextPrinter<T> printer;

    public Equals(Class<T> type, Collection<T> equaledValues, TextPrinter<T> printer) {
        Equals.checkPreconditions(type, equaledValues, printer);
        this.type = type;
        this.equaledValues = equaledValues.stream().distinct().collect(Collectors.toList());
        this.printer = printer;
    }

    public Equals(Class<T> type, Collection<T> equaledValues, TextPrinter<T> printer, CellProcessor next) {
        super(next);
        Equals.checkPreconditions(type, equaledValues, printer);
        this.type = type;
        this.equaledValues = equaledValues.stream().distinct().collect(Collectors.toList());
        this.printer = printer;
    }

    private static <T> void checkPreconditions(Class<T> type, Collection<T> equaledValues, TextPrinter<T> printer) {
        if (type == null || equaledValues == null || printer == null) {
            throw new NullPointerException("type or equaledValues or printer, field should not be null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        if (!this.type.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(this.type, value, context, (CellProcessor)this);
        }
        Object result = value;
        if (!this.equaledValues.isEmpty() && !this.equaledValues.contains(value)) {
            String formattedValue = this.printer.print(result);
            String joinedFormattedValues = this.equaledValues.stream().map(v -> this.printer.print(v)).collect(Collectors.joining(", "));
            throw this.createValidationException(context).rejectedValue(result).messageFormat("'%s' is not equals any of [%s].", formattedValue, joinedFormattedValues).messageVariables("equalsValues", this.equaledValues).messageVariables("printer", this.getPrinter()).build();
        }
        return this.next.execute(value, context);
    }

    public Collection<T> getEqualedValues() {
        return this.equaledValues;
    }

    public TextPrinter<T> getPrinter() {
        return this.printer;
    }
}

