/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor;

import com.github.mygreen.supercsv.annotation.conversion.CsvConversion;
import com.github.mygreen.supercsv.builder.BuildCase;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConversionProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.ProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.util.Utils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class ConversionProcessorHandler
implements ProcessorFactory {
    private static Logger logger = LoggerFactory.getLogger(ConversionProcessorHandler.class);
    private final Map<Class<? extends Annotation>, ConversionProcessorFactory<?>> factoryMap = new HashMap();

    @Override
    public Optional<CellProcessor> create(Optional<CellProcessor> processor, FieldAccessor field, TextFormatter<?> formatter, Configuration config, BuildCase buildCase, Class<?>[] groups) {
        List annos = field.getAnnotationsByGroup(groups).stream().filter(anno -> anno.annotationType().getAnnotation(CsvConversion.class) != null).filter(anno -> Utils.containsBuildCase(anno, buildCase)).collect(Collectors.toList());
        Collections.reverse(annos);
        Optional<CellProcessor> cp = processor;
        for (Annotation anno2 : annos) {
            CsvConversion conversionAnno = anno2.annotationType().getAnnotation(CsvConversion.class);
            if (this.factoryMap.containsKey(anno2.annotationType())) {
                ConversionProcessorFactory<?> factory = this.factoryMap.get(anno2.annotationType());
                cp = factory.create(anno2, cp, field, formatter, config);
                continue;
            }
            if (conversionAnno.value().length > 0) {
                for (Class<? extends ConversionProcessorFactory<?>> factoryClass : conversionAnno.value()) {
                    ConversionProcessorFactory factory = (ConversionProcessorFactory)config.getBeanFactory().create(factoryClass);
                    cp = factory.create(anno2, cp, field, formatter, config);
                }
                continue;
            }
            logger.warn("Not found {} with the annotation {}.", (Object)ConversionProcessorFactory.class.getSimpleName(), anno2.getClass());
        }
        return cp;
    }

    public <A extends Annotation> void register(Class<A> anno, ConversionProcessorFactory<A> factory) {
        this.factoryMap.put(anno, factory);
    }

    public Set<Map.Entry<Class<? extends Annotation>, ConversionProcessorFactory<?>>> getEntrySet() {
        return this.factoryMap.entrySet();
    }
}

