/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder.time;

import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeMax;
import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeMin;
import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeRange;
import com.github.mygreen.supercsv.annotation.format.CsvDateTimeFormat;
import com.github.mygreen.supercsv.builder.AbstractProcessorBuilder;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeMaxFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeMinFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeRangeFactory;
import com.github.mygreen.supercsv.cellprocessor.format.TemporalFormatWrapper;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.util.Utils;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

public abstract class AbstractTemporalProcessorBuilder<T extends TemporalAccessor & Comparable<? super T>>
extends AbstractProcessorBuilder<T> {
    @Override
    protected void init() {
        super.init();
        this.registerForConstraint(CsvDateTimeRange.class, new DateTimeRangeFactory());
        this.registerForConstraint(CsvDateTimeMin.class, new DateTimeMinFactory());
        this.registerForConstraint(CsvDateTimeMax.class, new DateTimeMaxFactory());
    }

    protected DateTimeFormatter createFormatter(FieldAccessor field, Configuration config) {
        Optional<CsvDateTimeFormat> formatAnno = field.getAnnotation(CsvDateTimeFormat.class);
        if (!formatAnno.isPresent()) {
            return DateTimeFormatter.ofPattern(this.getDefaultPattern());
        }
        String pattern = formatAnno.get().pattern();
        if (pattern.isEmpty()) {
            pattern = this.getDefaultPattern();
        }
        ResolverStyle style = formatAnno.get().lenient() ? ResolverStyle.LENIENT : ResolverStyle.STRICT;
        Locale locale = Utils.getLocale(formatAnno.get().locale());
        ZoneId zone = formatAnno.get().timezone().isEmpty() ? ZoneId.systemDefault() : TimeZone.getTimeZone(formatAnno.get().timezone()).toZoneId();
        return DateTimeFormatter.ofPattern(pattern, locale).withResolverStyle(style).withZone(zone);
    }

    @Override
    protected TextFormatter<T> getDefaultFormatter(FieldAccessor field, Configuration config) {
        Optional<CsvDateTimeFormat> formatAnno = field.getAnnotation(CsvDateTimeFormat.class);
        String pattern = this.getPattern(field);
        DateTimeFormatter formatter = this.createFormatter(field, config);
        TemporalFormatWrapper wrapper = new TemporalFormatWrapper(formatter, field.getType());
        wrapper.setPattern(pattern);
        formatAnno.ifPresent(a -> wrapper.setValidationMessage(a.message()));
        return wrapper;
    }

    protected String getPattern(FieldAccessor field) {
        return field.getAnnotation(CsvDateTimeFormat.class).map(a -> a.pattern()).filter(p -> !p.isEmpty()).orElse(this.getDefaultPattern());
    }

    protected abstract String getDefaultPattern();
}

