/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder.standard;

import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeMax;
import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeMin;
import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeRange;
import com.github.mygreen.supercsv.annotation.format.CsvDateTimeFormat;
import com.github.mygreen.supercsv.builder.AbstractProcessorBuilder;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeMaxFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeMinFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeRangeFactory;
import com.github.mygreen.supercsv.cellprocessor.format.AbstractTextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.DateFormatWrapper;
import com.github.mygreen.supercsv.cellprocessor.format.SimpleDateFormatBuilder;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.util.Utils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;

public class CalendarProcessorBuilder
extends AbstractProcessorBuilder<Calendar> {
    @Override
    protected void init() {
        super.init();
        this.registerForConstraint(CsvDateTimeRange.class, new DateTimeRangeFactory());
        this.registerForConstraint(CsvDateTimeMin.class, new DateTimeMinFactory());
        this.registerForConstraint(CsvDateTimeMax.class, new DateTimeMaxFactory());
    }

    @Override
    protected TextFormatter<Calendar> getDefaultFormatter(final FieldAccessor field, Configuration config) {
        final DateFormatWrapper<Date> dateFormatter = this.getDateFormatter(field, config);
        return new AbstractTextFormatter<Calendar>(){

            @Override
            public String print(Calendar object) {
                return dateFormatter.print(object.getTime());
            }

            @Override
            public Calendar parse(String text) {
                Date date = (Date)dateFormatter.parse(text);
                Calendar cal = CalendarProcessorBuilder.this.createDefaultCalendar(field);
                cal.setTime(date);
                return cal;
            }

            @Override
            public Optional<String> getPattern() {
                return dateFormatter.getPattern();
            }

            @Override
            public void setValidationMessage(String validationMessage) {
                dateFormatter.setValidationMessage(validationMessage);
            }

            @Override
            public Map<String, Object> getMessageVariables() {
                return dateFormatter.getMessageVariables();
            }

            @Override
            public Optional<String> getValidationMessage() {
                return dateFormatter.getValidationMessage();
            }
        };
    }

    private DateFormatWrapper<Date> getDateFormatter(FieldAccessor field, Configuration config) {
        String defaultPattern = "yyyy-MM-dd HH:mm:ss";
        Optional<CsvDateTimeFormat> formatAnno = field.getAnnotation(CsvDateTimeFormat.class);
        if (!formatAnno.isPresent()) {
            return new DateFormatWrapper<Date>(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), Date.class);
        }
        String pattern = formatAnno.get().pattern();
        if (pattern.isEmpty()) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        boolean lenient = formatAnno.get().lenient();
        Locale locale = Utils.getLocale(formatAnno.get().locale());
        TimeZone timeZone = formatAnno.get().timezone().isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(formatAnno.get().timezone());
        SimpleDateFormat formatter = SimpleDateFormatBuilder.create(pattern).lenient(lenient).locale(locale).timeZone(timeZone).build();
        DateFormatWrapper<Date> wrapper = new DateFormatWrapper<Date>(formatter, Date.class);
        wrapper.setValidationMessage(formatAnno.get().message());
        return wrapper;
    }

    private Calendar createDefaultCalendar(FieldAccessor field) {
        Optional<CsvDateTimeFormat> formatAnno = field.getAnnotation(CsvDateTimeFormat.class);
        if (!formatAnno.isPresent()) {
            return Calendar.getInstance();
        }
        Locale locale = Utils.getLocale(formatAnno.get().locale());
        TimeZone timeZone = formatAnno.get().timezone().isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(formatAnno.get().timezone());
        return Calendar.getInstance(timeZone, locale);
    }
}

