/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.builder.CallbackMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.supercsv.exception.SuperCsvReflectionException;

public class ListenerCallbackMethod
extends CallbackMethod {
    private final Object listener;

    public ListenerCallbackMethod(Object listener, Method method) {
        super(method);
        Objects.requireNonNull(listener);
        this.listener = listener;
    }

    @Override
    protected void execute(Object record, Object[] paramValues) {
        try {
            this.method.invoke(this.listener, paramValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            throw new SuperCsvReflectionException(String.format("Fail execute method '%s#%s'.", this.listener.getClass().getName(), this.method.getName()), t);
        }
    }
}

