/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.annotation.CsvBean;
import com.github.mygreen.supercsv.annotation.CsvColumn;
import com.github.mygreen.supercsv.annotation.CsvPartial;
import com.github.mygreen.supercsv.annotation.CsvPostRead;
import com.github.mygreen.supercsv.annotation.CsvPostWrite;
import com.github.mygreen.supercsv.annotation.CsvPreRead;
import com.github.mygreen.supercsv.annotation.CsvPreWrite;
import com.github.mygreen.supercsv.builder.AbstractProcessorBuilder;
import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.BeanMappingFactoryHelper;
import com.github.mygreen.supercsv.builder.CallbackMethod;
import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.builder.GeneralProcessorBuilder;
import com.github.mygreen.supercsv.builder.HeaderMapper;
import com.github.mygreen.supercsv.builder.ListenerCallbackMethod;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import com.github.mygreen.supercsv.validation.CsvValidator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.supercsv.exception.SuperCsvReflectionException;

public class BeanMappingFactory {
    private Configuration configuration = new Configuration();

    public <T> BeanMapping<T> create(Class<T> beanType, Class<?> ... groups) {
        Objects.requireNonNull(beanType);
        BeanMapping<T> beanMapping = new BeanMapping<T>(beanType);
        beanMapping.setConfiguration(this.configuration);
        CsvBean beanAnno = beanType.getAnnotation(CsvBean.class);
        if (beanAnno == null) {
            throw new SuperCsvInvalidAnnotationException(beanAnno, MessageBuilder.create("anno.notFound").varWithClass("property", beanType).varWithAnno("anno", CsvBean.class).format());
        }
        this.buildHeaderMapper(beanMapping, beanAnno);
        this.buildValidators(beanMapping, beanAnno, groups);
        this.buildColumnMappingList(beanMapping, beanType, groups);
        this.buildCallbackMethods(beanMapping, beanType, beanAnno);
        return beanMapping;
    }

    protected <T> void buildHeaderMapper(BeanMapping<T> beanMapping, CsvBean beanAnno) {
        HeaderMapper headerMapper = (HeaderMapper)this.configuration.getBeanFactory().create(beanAnno.headerMapper());
        beanMapping.setHeaderMapper(headerMapper);
        beanMapping.setHeader(beanAnno.header());
        beanMapping.setValidateHeader(beanAnno.validateHeader());
    }

    protected <T> void buildValidators(BeanMapping<T> beanMapping, CsvBean beanAnno, Class<?>[] groups) {
        List validators = Arrays.stream(beanAnno.validators()).map(v -> (CsvValidator)this.configuration.getBeanFactory().create((Class<?>)v)).collect(Collectors.toList());
        beanMapping.addAllValidators(validators);
        beanMapping.setSkipValidationOnWrite(this.configuration.isSkipValidationOnWrite());
        beanMapping.setGroups(groups);
    }

    protected <T> void buildColumnMappingList(BeanMapping<T> beanMapping, Class<T> beanType, Class<?>[] groups) {
        ArrayList<ColumnMapping> columnMappingList = new ArrayList<ColumnMapping>();
        for (Field field : beanType.getDeclaredFields()) {
            CsvColumn columnAnno = field.getAnnotation(CsvColumn.class);
            if (columnAnno == null) continue;
            columnMappingList.add(this.createColumnMapping(field, columnAnno, groups));
        }
        columnMappingList.sort(null);
        this.validateColumnAndSupplyPartialColumn(beanType, columnMappingList);
        beanMapping.addAllColumns(columnMappingList);
    }

    protected ColumnMapping createColumnMapping(Field field, CsvColumn columnAnno, Class<?>[] groups) {
        GeneralProcessorBuilder builder;
        FieldAccessor fieldAccessor = new FieldAccessor(field, this.configuration.getAnnoationComparator());
        ColumnMapping columnMapping = new ColumnMapping();
        columnMapping.setField(fieldAccessor);
        columnMapping.setNumber(columnAnno.number());
        if (columnAnno.label().isEmpty()) {
            columnMapping.setLabel(field.getName());
        } else {
            columnMapping.setLabel(columnAnno.label());
        }
        if (columnAnno.builder().length == 0) {
            builder = this.configuration.getBuilderResolver().resolve(fieldAccessor.getType());
            if (builder == null) {
                builder = new GeneralProcessorBuilder();
            }
        } else {
            try {
                builder = (GeneralProcessorBuilder)this.configuration.getBeanFactory().create(columnAnno.builder()[0]);
            }
            catch (Throwable e) {
                throw new SuperCsvReflectionException(String.format("Fail create instance of %s with attribute 'builderClass' of @CsvColumn", columnAnno.builder()[0].getCanonicalName()), e);
            }
        }
        columnMapping.setCellProcessorForReading(builder.buildForReading(field.getType(), fieldAccessor, this.configuration, groups).orElse(null));
        columnMapping.setCellProcessorForWriting(builder.buildForWriting(field.getType(), fieldAccessor, this.configuration, groups).orElse(null));
        if (builder instanceof AbstractProcessorBuilder) {
            columnMapping.setFormatter(((AbstractProcessorBuilder)builder).getFormatter(fieldAccessor, this.configuration));
        }
        return columnMapping;
    }

    protected void validateColumnAndSupplyPartialColumn(Class<?> beanType, List<ColumnMapping> list) {
        Optional<CsvPartial> partialAnno = Optional.ofNullable(beanType.getAnnotation(CsvPartial.class));
        if (list.isEmpty()) {
            throw new SuperCsvInvalidAnnotationException(MessageBuilder.create("anno.notFound").varWithClass("property", beanType).varWithAnno("anno", CsvColumn.class).format());
        }
        BeanMappingFactoryHelper.validateDuplicatedColumnNumber(beanType, list);
        BeanMappingFactoryHelper.supplyLackedNumberMappingColumn(beanType, list, partialAnno, new String[0]);
    }

    protected ColumnMapping createPartialColumnMapping(int columnNumber, Optional<CsvPartial> partialAnno) {
        ColumnMapping columnMapping = new ColumnMapping();
        columnMapping.setNumber(columnNumber);
        columnMapping.setPartialized(true);
        String label = String.format("column%d", columnNumber);
        if (partialAnno.isPresent()) {
            for (CsvPartial.Header header : partialAnno.get().headers()) {
                if (header.number() != columnNumber) continue;
                label = header.label();
            }
        }
        columnMapping.setLabel(label);
        return columnMapping;
    }

    protected <T> void buildCallbackMethods(BeanMapping<T> beanMapping, Class<T> beanType, CsvBean beanAnno) {
        for (Method method : beanType.getDeclaredMethods()) {
            if (method.getAnnotation(CsvPreRead.class) != null) {
                beanMapping.addPreReadMethod(new CallbackMethod(method));
            }
            if (method.getAnnotation(CsvPostRead.class) != null) {
                beanMapping.addPostReadMethod(new CallbackMethod(method));
            }
            if (method.getAnnotation(CsvPreWrite.class) != null) {
                beanMapping.addPreWriteMethod(new CallbackMethod(method));
            }
            if (method.getAnnotation(CsvPostWrite.class) == null) continue;
            beanMapping.addPostWriteMethod(new CallbackMethod(method));
        }
        List<Object> listeners = Arrays.stream(beanAnno.listeners()).map(l -> this.configuration.getBeanFactory().create((Class<?>)l)).collect(Collectors.toList());
        beanMapping.addAllListeners(listeners);
        for (Object listener : listeners) {
            for (Method method : listener.getClass().getDeclaredMethods()) {
                if (method.getAnnotation(CsvPreRead.class) != null) {
                    beanMapping.addPreReadMethod(new ListenerCallbackMethod(listener, method));
                }
                if (method.getAnnotation(CsvPostRead.class) != null) {
                    beanMapping.addPostReadMethod(new ListenerCallbackMethod(listener, method));
                }
                if (method.getAnnotation(CsvPreWrite.class) != null) {
                    beanMapping.addPreWriteMethod(new ListenerCallbackMethod(listener, method));
                }
                if (method.getAnnotation(CsvPostWrite.class) == null) continue;
                beanMapping.addPostWriteMethod(new ListenerCallbackMethod(listener, method));
            }
        }
        beanMapping.getPreReadMethods().sort(null);
        beanMapping.getPostReadMethods().sort(null);
        beanMapping.getPreWriteMethods().sort(null);
        beanMapping.getPostWriteMethods().sort(null);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuraton) {
        this.configuration = configuraton;
    }
}

