/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.annotation.constraint.CsvEquals;
import com.github.mygreen.supercsv.annotation.constraint.CsvRequire;
import com.github.mygreen.supercsv.annotation.constraint.CsvUnique;
import com.github.mygreen.supercsv.annotation.constraint.CsvUniqueHashCode;
import com.github.mygreen.supercsv.annotation.conversion.CsvDefaultValue;
import com.github.mygreen.supercsv.annotation.conversion.CsvFullChar;
import com.github.mygreen.supercsv.annotation.conversion.CsvHalfChar;
import com.github.mygreen.supercsv.annotation.conversion.CsvLeftPad;
import com.github.mygreen.supercsv.annotation.conversion.CsvLower;
import com.github.mygreen.supercsv.annotation.conversion.CsvMultiPad;
import com.github.mygreen.supercsv.annotation.conversion.CsvNullConvert;
import com.github.mygreen.supercsv.annotation.conversion.CsvOneSideTrim;
import com.github.mygreen.supercsv.annotation.conversion.CsvRegexReplace;
import com.github.mygreen.supercsv.annotation.conversion.CsvRightPad;
import com.github.mygreen.supercsv.annotation.conversion.CsvTrim;
import com.github.mygreen.supercsv.annotation.conversion.CsvUpper;
import com.github.mygreen.supercsv.annotation.conversion.CsvWordReplace;
import com.github.mygreen.supercsv.annotation.format.CsvFormat;
import com.github.mygreen.supercsv.builder.BuildCase;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.builder.ProcessorBuilder;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorHandler;
import com.github.mygreen.supercsv.cellprocessor.ConversionProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.ConversionProcessorHandler;
import com.github.mygreen.supercsv.cellprocessor.ProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.EqualsFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.RequireFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.UniqueFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.UniqueHashCodeFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.DefaultValueFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.FullCharFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.HalfCharFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.LeftPadFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.LowerFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.MultiPadFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.NullConvertFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.OneSideTrimFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.RegexReplaceFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.RightPadFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.TrimFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.UpperFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.WordReplaceFactory;
import com.github.mygreen.supercsv.cellprocessor.format.ParseProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.format.PrintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.supercsv.cellprocessor.ift.CellProcessor;

public abstract class AbstractProcessorBuilder<T>
implements ProcessorBuilder<T> {
    protected List<ProcessorFactory> readingFactory = new ArrayList<ProcessorFactory>();
    protected List<ProcessorFactory> writingFactory = new ArrayList<ProcessorFactory>();
    protected ConversionProcessorHandler conversionHandler = new ConversionProcessorHandler();
    protected ConstraintProcessorHandler constraintHandler = new ConstraintProcessorHandler();

    public AbstractProcessorBuilder() {
        this.init();
    }

    protected void init() {
        this.registerForReading(this.conversionHandler);
        this.registerForReading(new ParseProcessorFactory());
        this.registerForReading(this.constraintHandler);
        this.registerForWriting(this.constraintHandler);
        this.registerForWriting(new PrintProcessorFactory());
        this.registerForWriting(this.conversionHandler);
        this.registerForConversion(CsvNullConvert.class, new NullConvertFactory());
        this.registerForConversion(CsvDefaultValue.class, new DefaultValueFactory());
        this.registerForConversion(CsvTrim.class, new TrimFactory());
        this.registerForConversion(CsvUpper.class, new UpperFactory());
        this.registerForConversion(CsvLower.class, new LowerFactory());
        this.registerForConversion(CsvRegexReplace.class, new RegexReplaceFactory());
        this.registerForConversion(CsvWordReplace.class, new WordReplaceFactory());
        this.registerForConversion(CsvFullChar.class, new FullCharFactory());
        this.registerForConversion(CsvHalfChar.class, new HalfCharFactory());
        this.registerForConversion(CsvLeftPad.class, new LeftPadFactory());
        this.registerForConversion(CsvRightPad.class, new RightPadFactory());
        this.registerForConversion(CsvMultiPad.class, new MultiPadFactory());
        this.registerForConversion(CsvOneSideTrim.class, new OneSideTrimFactory());
        this.registerForConstraint(CsvRequire.class, new RequireFactory());
        this.registerForConstraint(CsvUnique.class, new UniqueFactory());
        this.registerForConstraint(CsvUniqueHashCode.class, new UniqueHashCodeFactory());
        this.registerForConstraint(CsvEquals.class, new EqualsFactory());
    }

    @Override
    public Optional<CellProcessor> buildForReading(Class<T> type, FieldAccessor field, Configuration config, Class<?>[] groups) {
        ArrayList<ProcessorFactory> factories = new ArrayList<ProcessorFactory>(this.readingFactory);
        Collections.reverse(factories);
        TextFormatter<T> formatter = this.getFormatter(field, config);
        Optional<CellProcessor> processor = Optional.empty();
        for (ProcessorFactory factory : factories) {
            processor = factory.create(processor, field, formatter, config, BuildCase.Read, groups);
        }
        return processor;
    }

    @Override
    public Optional<CellProcessor> buildForWriting(Class<T> type, FieldAccessor field, Configuration config, Class<?>[] groups) {
        ArrayList<ProcessorFactory> factories = new ArrayList<ProcessorFactory>(this.writingFactory);
        Collections.reverse(factories);
        TextFormatter<T> formatter = this.getFormatter(field, config);
        Optional<CellProcessor> processor = Optional.empty();
        for (ProcessorFactory factory : factories) {
            if (config.isSkipValidationOnWrite() && factory instanceof ConstraintProcessorHandler) continue;
            processor = factory.create(processor, field, formatter, config, BuildCase.Write, groups);
        }
        return processor;
    }

    public void registerForReading(ProcessorFactory factory) {
        this.readingFactory.add(factory);
    }

    public void registerForWriting(ProcessorFactory factory) {
        this.writingFactory.add(factory);
    }

    public <A extends Annotation> void registerForConversion(Class<A> anno, ConversionProcessorFactory<A> factory) {
        this.conversionHandler.register(anno, factory);
    }

    public <A extends Annotation> void registerForConstraint(Class<A> anno, ConstraintProcessorFactory<A> factory) {
        this.constraintHandler.register(anno, factory);
    }

    public TextFormatter<T> getFormatter(FieldAccessor field, Configuration config) {
        if (field.hasAnnotation(CsvFormat.class)) {
            CsvFormat formatAnno = field.getAnnotation(CsvFormat.class).get();
            TextFormatter formatter = (TextFormatter)config.getBeanFactory().create(formatAnno.formatter());
            if (!formatAnno.message().isEmpty()) {
                formatter.setValidationMessage(formatAnno.message());
            }
            return formatter;
        }
        return this.getDefaultFormatter(field, config);
    }

    protected abstract TextFormatter<T> getDefaultFormatter(FieldAccessor var1, Configuration var2);

    public Set<Map.Entry<Class<? extends Annotation>, ConversionProcessorFactory<?>>> getEntrySetForConversion() {
        return this.conversionHandler.getEntrySet();
    }

    public Set<Map.Entry<Class<? extends Annotation>, ConstraintProcessorFactory<?>>> getEntrySetForConsraint() {
        return this.constraintHandler.getEntrySet();
    }
}

