/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.supercsv.ext.util.ConversionException;

public class NumberFormatWrapper {
    private final NumberFormat formatter;
    private final boolean lenient;

    public NumberFormatWrapper(NumberFormat formatter) {
        this(formatter, false);
    }

    public NumberFormatWrapper(NumberFormat formatter, boolean lenient) {
        if (formatter == null) {
            throw new NullPointerException("formatter should not be null.");
        }
        this.formatter = (NumberFormat)formatter.clone();
        this.lenient = lenient;
    }

    public synchronized <N extends Number> String format(N number) {
        return this.formatter.format(number);
    }

    public synchronized <N extends Number> N parse(Class<N> type, String value) throws ParseException, ConversionException {
        Number result;
        if (this.lenient) {
            result = this.formatter.parse(value);
        } else {
            ParsePosition position = new ParsePosition(0);
            result = this.formatter.parse(value, position);
            if (position.getIndex() != value.length()) {
                throw new ParseException(String.format("Cannot parse '%s' using fromat %s", value, this.getPattern()), position.getIndex());
            }
        }
        try {
            if (result instanceof BigDecimal) {
                return (N)this.convertWithBigDecimal(type, (BigDecimal)result, value);
            }
            return (N)this.convertWithNumber(type, result, value);
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new ConversionException(value, type, e);
        }
    }

    private Number convertWithNumber(Class<? extends Number> type, Number number, String str) {
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
            return number.byteValue();
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
            return number.shortValue();
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return number.intValue();
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return number.longValue();
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return number.doubleValue();
        }
        if (type.isAssignableFrom(BigInteger.class)) {
            return new BigInteger(str);
        }
        if (type.isAssignableFrom(BigDecimal.class)) {
            return new BigDecimal(str);
        }
        throw new IllegalArgumentException(String.format("not support class type : %s", type.getCanonicalName()));
    }

    private Number convertWithBigDecimal(Class<? extends Number> type, BigDecimal number, String str) {
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.byteValue() : number.byteValueExact();
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.shortValue() : number.shortValueExact();
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.intValue() : number.intValueExact();
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.longValue() : number.longValueExact();
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return number.doubleValue();
        }
        if (type.isAssignableFrom(BigInteger.class)) {
            return this.lenient ? number.toBigInteger() : number.toBigIntegerExact();
        }
        if (type.isAssignableFrom(BigDecimal.class)) {
            return number;
        }
        throw new IllegalArgumentException(String.format("not support class type : %s", type.getCanonicalName()));
    }

    public String getPattern() {
        if (this.formatter instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)this.formatter;
            return df.toPattern();
        }
        return null;
    }

    public boolean isLenient() {
        return this.lenient;
    }
}

