/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.time;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class TemporalRange<T extends TemporalAccessor & Comparable<? super T>>
extends CellProcessorAdaptor
implements DateCellProcessor,
ValidationCellProcessor {
    private final T min;
    private final T max;
    private DateTimeFormatter formatter;

    public TemporalRange(T min, T max) {
        TemporalRange.checkPreconditions(min, max);
        this.min = min;
        this.max = max;
    }

    public TemporalRange(T min, T max, CellProcessor next) {
        super(next);
        TemporalRange.checkPreconditions(min, max);
        this.min = min;
        this.max = max;
    }

    private static <T extends TemporalAccessor & Comparable<? super T>> void checkPreconditions(T min, T max) {
        if (min == null || max == null) {
            throw new NullPointerException("min and max should not be null");
        }
        if (((Comparable<T>)min).compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("max (%s) should not be < min (%s)", max, min));
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        Class<?> exepectedClass = this.getMin().getClass();
        if (!exepectedClass.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(exepectedClass, value, context, (CellProcessor)this);
        }
        TemporalAccessor result = (TemporalAccessor)value;
        if (((Comparable)((Object)result)).compareTo(this.min) < 0 || ((Comparable)((Object)result)).compareTo(this.max) > 0) {
            throw new SuperCsvConstraintViolationException(String.format("%s does not lie between the min (%s) and max (%s) values (inclusive)", result, this.min, this.max), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, T> vars = new HashMap<String, T>();
        vars.put("min", this.getMin());
        vars.put("max", this.getMax());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof TemporalAccessor) {
            TemporalAccessor temporal = (TemporalAccessor)value;
            if (this.getFormatter() != null) {
                return this.getFormatter().format(temporal);
            }
        }
        return value.toString();
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }
}

