/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.time;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class PastTemporal<T extends TemporalAccessor & Comparable<? super T>>
extends CellProcessorAdaptor
implements DateCellProcessor,
ValidationCellProcessor {
    private final T max;
    private DateTimeFormatter formatter;

    public PastTemporal(T max) {
        PastTemporal.checkPreconditions(max);
        this.max = max;
    }

    public PastTemporal(T max, CellProcessor next) {
        super(next);
        PastTemporal.checkPreconditions(max);
        this.max = max;
    }

    protected static <T extends TemporalAccessor & Comparable<? super T>> void checkPreconditions(T max) {
        if (max == null) {
            throw new NullPointerException("max should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        Class<?> exepectedClass = this.getMax().getClass();
        if (!exepectedClass.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(exepectedClass, value, context, (CellProcessor)this);
        }
        TemporalAccessor result = (TemporalAccessor)value;
        if (((Comparable)((Object)result)).compareTo(this.max) > 0) {
            throw new SuperCsvConstraintViolationException(String.format("%s does not lie the max (%s) values (inclusive)", result, this.max), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, T> vars = new HashMap<String, T>();
        vars.put("max", this.getMax());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof TemporalAccessor) {
            TemporalAccessor temporal = (TemporalAccessor)value;
            if (this.getFormatter() != null) {
                return this.getFormatter().format(temporal);
            }
        }
        return value.toString();
    }

    public T getMax() {
        return this.max;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }
}

