/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.ext.util.DateFormatWrapper;
import org.supercsv.util.CsvContext;

public class PastDate<T extends Date>
extends CellProcessorAdaptor
implements DateCellProcessor,
ValidationCellProcessor {
    protected final T max;
    protected DateFormat formatter;

    public PastDate(T max) {
        PastDate.checkPreconditions(max);
        this.max = max;
    }

    public PastDate(T max, CellProcessor next) {
        super(next);
        PastDate.checkPreconditions(max);
        this.max = max;
    }

    protected static <T extends Date> void checkPreconditions(T max) {
        if (max == null) {
            throw new NullPointerException("max should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!Date.class.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(Date.class, value, context, (CellProcessor)this);
        }
        Date result = (Date)value;
        if (result.compareTo((Date)this.max) > 0) {
            throw new SuperCsvConstraintViolationException(String.format("%s does not lie the max (%s) values (inclusive)", result, this.max), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    public T getMax() {
        return this.max;
    }

    public DateFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DateFormat formatter) {
        this.formatter = formatter;
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, T> vars = new HashMap<String, T>();
        vars.put("max", this.getMax());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            DateFormatWrapper df = this.getFormatter() != null ? new DateFormatWrapper(this.getFormatter()) : new DateFormatWrapper(date.getClass());
            return df.format(date);
        }
        return value.toString();
    }
}

