/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.joda;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.joda.FmtLocalDateTime;
import org.supercsv.cellprocessor.joda.ParseLocalDateTime;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.joda.AbstractJodaCellProcessorBuilder;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class LocalDateTimeCellProcessorBuilder
extends AbstractJodaCellProcessorBuilder<LocalDateTime> {
    @Override
    protected String getDefaultPattern() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    @Override
    public Optional<LocalDateTime> parseValue(Class<LocalDateTime> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        String pattern = this.getPattern(converterAnno);
        try {
            return Optional.of(LocalDateTime.parse((String)strValue, (DateTimeFormatter)formatter));
        }
        catch (IllegalArgumentException e) {
            throw new SuperCsvInvalidAnnotationException(String.format("default '%s' value cannot parse to LocalDateTime with pattern '%s'", strValue, pattern), e);
        }
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<LocalDateTime> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        Optional<LocalDateTime> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<LocalDateTime> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        CellProcessor cp = processor;
        FmtLocalDateTime fmtLocalDateTime = cp = cp == null ? new FmtLocalDateTime(formatter) : new FmtLocalDateTime(formatter, cp);
        if (!ignoreValidationProcessor) {
            cp = this.prependRangeProcessor(type, annos, cp, min, max);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<LocalDateTime> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        Optional<LocalDateTime> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<LocalDateTime> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        CellProcessor cp = processor;
        cp = (cp = this.prependRangeProcessor(type, annos, cp, min, max)) == null ? new ParseLocalDateTime(formatter) : new ParseLocalDateTime(formatter, cp);
        return cp;
    }
}

