/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.joda;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.joda.FutureJoda;
import org.supercsv.ext.cellprocessor.joda.JodaRange;
import org.supercsv.ext.cellprocessor.joda.PastJoda;
import org.supercsv.ext.util.Utils;

public abstract class AbstractJodaCellProcessorBuilder<T extends ReadablePartial>
extends AbstractCellProcessorBuilder<T> {
    protected Optional<CsvDateConverter> getDateConverterAnnotation(Annotation[] annos) {
        return AbstractJodaCellProcessorBuilder.getAnnotation(annos, CsvDateConverter.class);
    }

    protected String getPattern(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.pattern()).map(s -> s.isEmpty() ? this.getDefaultPattern() : s).orElse(this.getDefaultPattern());
    }

    protected Locale getLocale(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> Utils.getLocale(a.locale())).orElse(Locale.getDefault());
    }

    protected DateTimeZone getDateTimeZone(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(a.timezone()))).orElse(DateTimeZone.getDefault());
    }

    protected Optional<String> getMin(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.min()).filter(s -> s.length() > 0);
    }

    protected Optional<String> getMax(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.max()).filter(s -> s.length() > 0);
    }

    protected CellProcessor prependRangeProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor, Optional<T> min, Optional<T> max) {
        DateTimeFormatter formatter = this.createDateTimeFormatter(this.getDateConverterAnnotation(annos));
        if (min.isPresent() && max.isPresent()) {
            JodaRange<ReadablePartial> cp = cellProcessor == null ? new JodaRange<ReadablePartial>((ReadablePartial)min.get(), (ReadablePartial)max.get()) : new JodaRange<ReadablePartial>((ReadablePartial)min.get(), (ReadablePartial)max.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        if (min.isPresent()) {
            FutureJoda<ReadablePartial> cp = cellProcessor == null ? new FutureJoda<ReadablePartial>((ReadablePartial)min.get()) : new FutureJoda<ReadablePartial>((ReadablePartial)min.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        if (max.isPresent()) {
            PastJoda<ReadablePartial> cp = cellProcessor == null ? new PastJoda<ReadablePartial>((ReadablePartial)max.get()) : new PastJoda<ReadablePartial>((ReadablePartial)max.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        return cellProcessor;
    }

    protected abstract String getDefaultPattern();

    protected DateTimeFormatter createDateTimeFormatter(Optional<CsvDateConverter> converterAnno) {
        String pattern = this.getPattern(converterAnno);
        Locale locale = this.getLocale(converterAnno);
        DateTimeZone zone = this.getDateTimeZone(converterAnno);
        return DateTimeFormat.forPattern((String)pattern).withLocale(locale).withZone(zone);
    }
}

