/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvColumn;
import org.supercsv.ext.annotation.CsvNumberConverter;
import org.supercsv.ext.builder.impl.AbstractNumberCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.FormatLocaleNumber;
import org.supercsv.ext.cellprocessor.ParseByte;
import org.supercsv.ext.cellprocessor.ParseLocaleNumber;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class ByteCellProcessorBuilder
extends AbstractNumberCellProcessorBuilder<Byte> {
    @Override
    protected CellProcessor buildInputCellProcessorWithConvertNullTo(Class<Byte> type, Annotation[] annos, CellProcessor cellProcessor, CsvColumn csvColumnAnno) {
        if (type.isPrimitive() && csvColumnAnno.optional() && csvColumnAnno.inputDefaultValue().isEmpty()) {
            return this.prependConvertNullToProcessor(type, annos, cellProcessor, (byte)0);
        }
        if (!csvColumnAnno.inputDefaultValue().isEmpty()) {
            Optional<Byte> value = this.parseValue(type, annos, csvColumnAnno.inputDefaultValue());
            return this.prependConvertNullToProcessor(type, annos, cellProcessor, value.get());
        }
        return cellProcessor;
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<Byte> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        Optional<Byte> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<Byte> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Object cp = processor;
        if (formatter.isPresent()) {
            FormatLocaleNumber formatLocaleNumber = cp = cp == null ? new FormatLocaleNumber(formatter.get()) : new FormatLocaleNumber(formatter.get(), (StringCellProcessor)cp);
        }
        if (!ignoreValidationProcessor) {
            cp = this.prependRangeProcessor(type, annos, (CellProcessor)cp, min, max);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<Byte> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        Optional<Byte> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<Byte> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Object cp = processor;
        cp = this.prependRangeProcessor(type, annos, (CellProcessor)cp, min, max);
        cp = formatter.isPresent() ? (cp == null ? new ParseLocaleNumber<Byte>(type, formatter.get(), lenient) : new ParseLocaleNumber<Byte>(type, formatter.get(), lenient, (CellProcessor)cp)) : (cp == null ? new ParseByte() : new ParseByte((LongCellProcessor)cp));
        return cp;
    }

    @Override
    public Optional<Byte> parseValue(Class<Byte> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        Optional<String> pattern = this.getPattern(converterAnno);
        if (formatter.isPresent()) {
            try {
                return Optional.of(formatter.get().parse(strValue).byteValue());
            }
            catch (ParseException e) {
                throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Number with pattern '%s'", strValue, pattern.get()), e);
            }
        }
        return Optional.of(Byte.valueOf(strValue));
    }
}

