/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.supercsv.ext.builder.CellProcessorBuilder;
import org.supercsv.ext.builder.CellProcessorBuilderFactory;

public class SpringCellProcessorBuilderFacatory
implements CellProcessorBuilderFactory,
ApplicationContextAware,
InitializingBean {
    private AutowireCapableBeanFactory beanFactory;
    private ApplicationContext applicationContext;

    @Override
    public <T extends CellProcessorBuilder<?>> T create(Class<T> builderClass) throws Exception {
        Assert.notNull(builderClass, (String)"builderClass must not be null");
        return (T)((CellProcessorBuilder)this.beanFactory.createBean(builderClass));
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationContext != null && this.beanFactory == null) {
            this.beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public AutowireCapableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

